/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth.role;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.PriPrivilegeType;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.auth.role.LocalFileRoleAccessor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LocalFileRoleAccessorTest {
    private File testFolder;
    private LocalFileRoleAccessor accessor;

    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
        this.testFolder = new File(TestConstant.BASE_OUTPUT_PATH.concat("test"));
        this.testFolder.mkdirs();
        this.accessor = new LocalFileRoleAccessor(this.testFolder.getPath());
    }

    @After
    public void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)this.testFolder);
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void test() throws IOException, IllegalPathException {
        Role[] roles = new Role[4];
        for (int i = 0; i < roles.length; ++i) {
            roles[i] = new Role("role" + i);
            for (int j = 0; j <= i; ++j) {
                PathPrivilege pathPrivilege = new PathPrivilege(new PartialPath("root.a.b.c" + j));
                pathPrivilege.getPrivileges().add(j);
                roles[i].getPathPrivilegeList().add(pathPrivilege);
                roles[i].getSysPrivilege().add(i + 4);
                if (i % 2 == 0) continue;
                roles[i].getSysPriGrantOpt().add(i + 4);
            }
        }
        for (Role role : roles) {
            this.accessor.saveRole(role);
        }
        for (Role role : roles) {
            Role loadedRole = this.accessor.loadRole(role.getName());
            Assert.assertEquals((Object)role, (Object)loadedRole);
        }
        Assert.assertNull((Object)this.accessor.loadRole("not a role"));
        Assert.assertTrue((boolean)this.accessor.deleteRole(roles[roles.length - 1].getName()));
        Assert.assertFalse((boolean)this.accessor.deleteRole(roles[roles.length - 1].getName()));
        Assert.assertNull((Object)this.accessor.loadRole(roles[roles.length - 1].getName()));
        List roleNames = this.accessor.listAllRoles();
        roleNames.sort(null);
        for (int i = 0; i < roleNames.size(); ++i) {
            Assert.assertEquals((Object)roles[i].getName(), roleNames.get(i));
        }
    }

    @Test
    public void testLoadOldVersion() throws IOException, IllegalPathException {
        Role role = new Role();
        role.setName("root");
        ArrayList<PathPrivilege> pathPriList = new ArrayList<PathPrivilege>();
        PathPrivilege rootPathPriv = new PathPrivilege(new PartialPath("root.**"));
        PathPrivilege normalPathPriv = new PathPrivilege(new PartialPath("root.b.c.**"));
        PathPrivilege wroPathPriv = new PathPrivilege(new PartialPath("root.c.*.d"));
        PathPrivilege wroPathPriv2 = new PathPrivilege(new PartialPath("root.c.*.**"));
        for (PriPrivilegeType item : PriPrivilegeType.values()) {
            if (item.ordinal() == PriPrivilegeType.ALL.ordinal()) continue;
            if (item.isPrePathRelevant()) {
                normalPathPriv.grantPrivilege(item.ordinal(), false);
                wroPathPriv.grantPrivilege(item.ordinal(), false);
                wroPathPriv2.grantPrivilege(item.ordinal(), false);
            }
            rootPathPriv.grantPrivilege(item.ordinal(), false);
        }
        pathPriList.add(rootPathPriv);
        pathPriList.add(normalPathPriv);
        pathPriList.add(wroPathPriv);
        pathPriList.add(wroPathPriv2);
        role.setPrivilegeList(pathPriList);
        role.setSysPriGrantOpt(new HashSet());
        role.setSysPrivilegeSet(new HashSet());
        this.accessor.saveRoleOldVer(role);
        Role newRole = this.accessor.loadRole("root");
        Assert.assertEquals((Object)"root", (Object)newRole.getName());
        Assert.assertFalse((boolean)newRole.getServiceReady());
        Assert.assertEquals((long)4L, (long)newRole.getPathPrivilegeList().size());
        for (PathPrivilege path : newRole.getPathPrivilegeList()) {
            if (!path.getPath().equals((Object)new PartialPath("root.**"))) {
                Assert.assertEquals((long)17L, (long)path.getPrivileges().size());
                continue;
            }
            Assert.assertEquals((long)33L, (long)path.getPrivileges().size());
        }
    }
}

