/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth.entity;

import java.util.Collections;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.junit.Assert;
import org.junit.Test;

public class RoleTest {
    @Test
    public void testRole_InitAndSerialize() throws IllegalPathException {
        Role role = new Role("role");
        PathPrivilege pathPrivilege = new PathPrivilege(new PartialPath("root.ln"));
        role.setPrivilegeList(Collections.singletonList(pathPrivilege));
        role.addPathPrivilege(new PartialPath("root.ln"), 1, false);
        role.addPathPrivilege(new PartialPath("root.ln"), 2, true);
        Assert.assertEquals((Object)"Role{name='role', pathPrivilegeList=[root.ln : WRITE_DATA READ_SCHEMA_with_grant_option], systemPrivilegeSet=[]}", (Object)role.toString());
        Role role1 = new Role("role1");
        role1.deserialize(role.serialize());
        Assert.assertEquals((Object)"Role{name='role', pathPrivilegeList=[root.ln : WRITE_DATA READ_SCHEMA_with_grant_option], systemPrivilegeSet=[]}", (Object)role1.toString());
        Role admin = new Role("root");
        PartialPath rootPath = new PartialPath("root.**");
        PathPrivilege pathPri = new PathPrivilege(rootPath);
        for (PrivilegeType item : PrivilegeType.values()) {
            if (!item.isPathRelevant()) {
                admin.getSysPrivilege().add(item.ordinal());
                admin.getSysPriGrantOpt().add(item.ordinal());
                continue;
            }
            pathPri.grantPrivilege(item.ordinal(), true);
        }
        admin.getPathPrivilegeList().add(pathPri);
        Assert.assertEquals((Object)"Role{name='root', pathPrivilegeList=[root.** : READ_DATA_with_grant_option WRITE_DATA_with_grant_option READ_SCHEMA_with_grant_option WRITE_SCHEMA_with_grant_option], systemPrivilegeSet=[MANAGE_ROLE_with_grant_option , USE_UDF_with_grant_option , USE_CQ_with_grant_option , USE_PIPE_with_grant_option , USE_TRIGGER_with_grant_option , MANAGE_DATABASE_with_grant_option , MANAGE_USER_with_grant_option , MAINTAIN_with_grant_option , EXTEND_TEMPLATE_with_grant_option , USE_MODEL_with_grant_option ]}", (Object)admin.toString());
    }
}

