/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth.entity;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.junit.Assert;
import org.junit.Test;

public class PathPrivilegeTest {
    @Test
    public void testPathPrivilege_Init() throws IllegalPathException {
        PathPrivilege pathPrivilege = new PathPrivilege();
        pathPrivilege.setPath(new PartialPath("root.ln"));
        pathPrivilege.setPrivileges(Collections.singleton(1));
        pathPrivilege.setGrantOpt(new HashSet());
        Assert.assertEquals((Object)"root.ln : WRITE_DATA", (Object)pathPrivilege.toString());
        PathPrivilege pathPrivilege1 = new PathPrivilege();
        pathPrivilege1.setPath(new PartialPath("root.sg"));
        pathPrivilege1.setPrivileges(Collections.singleton(1));
        pathPrivilege1.setGrantOpt(new HashSet());
        Assert.assertNotEquals((Object)pathPrivilege, (Object)pathPrivilege1);
        pathPrivilege.deserialize(pathPrivilege1.serialize());
        Assert.assertEquals((Object)"root.sg : WRITE_DATA", (Object)pathPrivilege.toString());
    }

    @Test
    public void testPathPrivilege_GrantAndRevoke() throws IllegalPathException {
        PathPrivilege pathPrivilege = new PathPrivilege(new PartialPath("root.ln"));
        pathPrivilege.grantPrivilege(PrivilegeType.READ_DATA.ordinal(), false);
        pathPrivilege.grantPrivilege(PrivilegeType.READ_SCHEMA.ordinal(), true);
        pathPrivilege.grantPrivilege(PrivilegeType.WRITE_SCHEMA.ordinal(), true);
        Assert.assertEquals((long)pathPrivilege.getPrivileges().size(), (long)3L);
        Assert.assertEquals((long)pathPrivilege.getGrantOpt().size(), (long)2L);
        Assert.assertTrue((boolean)pathPrivilege.getGrantOpt().contains(PrivilegeType.READ_SCHEMA.ordinal()));
        Assert.assertTrue((boolean)pathPrivilege.getGrantOpt().contains(PrivilegeType.WRITE_SCHEMA.ordinal()));
        pathPrivilege.revokePrivilege(PrivilegeType.READ_SCHEMA.ordinal());
        Assert.assertFalse((boolean)pathPrivilege.revokePrivilege(PrivilegeType.READ_SCHEMA.ordinal()));
        HashSet<Integer> privs = new HashSet<Integer>();
        privs.add(PrivilegeType.WRITE_SCHEMA.ordinal());
        Assert.assertEquals((Object)pathPrivilege.getGrantOpt(), privs);
        privs.add(PrivilegeType.READ_DATA.ordinal());
        Assert.assertEquals((Object)pathPrivilege.getPrivileges(), privs);
        Assert.assertFalse((boolean)pathPrivilege.revokeGrantOpt(PrivilegeType.READ_SCHEMA.ordinal()));
        Assert.assertTrue((boolean)pathPrivilege.revokeGrantOpt(PrivilegeType.WRITE_SCHEMA.ordinal()));
        Assert.assertEquals((long)pathPrivilege.getGrantOpt().size(), (long)0L);
    }

    @Test
    public void testPrivilegePath_GetAllPrivilegeMask() throws IllegalPathException {
        PathPrivilege pathPrivilege = new PathPrivilege(new PartialPath("root.ln"));
        pathPrivilege.grantPrivilege(PrivilegeType.READ_DATA.ordinal(), false);
        pathPrivilege.grantPrivilege(PrivilegeType.READ_SCHEMA.ordinal(), true);
        pathPrivilege.grantPrivilege(PrivilegeType.WRITE_SCHEMA.ordinal(), true);
        Assert.assertEquals((long)pathPrivilege.getAllPrivileges(), (long)786445L);
        PathPrivilege pathPrivilege2 = new PathPrivilege(new PartialPath("root.ln"));
        pathPrivilege2.setAllPrivileges(786445);
        Assert.assertTrue((boolean)Objects.equals(pathPrivilege, pathPrivilege2));
    }
}

