/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.confignode.rpc.thrift.TPathPrivilege;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TRoleResp;
import org.apache.iotdb.confignode.rpc.thrift.TUserResp;
import org.apache.iotdb.db.auth.BasicAuthorityCache;
import org.apache.iotdb.db.auth.ClusterAuthorityFetcher;
import org.apache.iotdb.db.auth.IAuthorCache;
import org.junit.Assert;
import org.junit.Test;

public class AuthorizerManagerTest {
    ClusterAuthorityFetcher authorityFetcher = new ClusterAuthorityFetcher((IAuthorCache)new BasicAuthorityCache());

    @Test
    public void permissionCacheTest() throws IllegalPathException {
        User user = new User();
        Role role1 = new Role();
        Role role2 = new Role();
        ArrayList<String> roleList = new ArrayList<String>();
        HashSet<Integer> privilegesIds = new HashSet<Integer>();
        HashSet<Integer> sysPriIds = new HashSet<Integer>();
        PathPrivilege privilege = new PathPrivilege();
        ArrayList<PathPrivilege> privilegeList = new ArrayList<PathPrivilege>();
        privilegesIds.add(PrivilegeType.READ_DATA.ordinal());
        sysPriIds.add(PrivilegeType.MAINTAIN.ordinal());
        privilege.setPath(new PartialPath("root.ln"));
        privilege.setPrivileges(privilegesIds);
        privilegeList.add(privilege);
        role1.setName("role1");
        role1.setPrivilegeList(privilegeList);
        role2.setName("role2");
        role2.setPrivilegeList(new ArrayList());
        roleList.add("role1");
        roleList.add("role2");
        user.setName("user");
        user.setPassword("password");
        user.setPrivilegeList(privilegeList);
        user.setSysPrivilegeSet(sysPriIds);
        user.setRoleList(roleList);
        TPermissionInfoResp result = new TPermissionInfoResp();
        TUserResp tUserResp = new TUserResp();
        HashMap<String, TRoleResp> tRoleRespMap = new HashMap<String, TRoleResp>();
        ArrayList<TPathPrivilege> userPrivilegeList = new ArrayList<TPathPrivilege>();
        ArrayList<TPathPrivilege> rolePrivilegeList = new ArrayList<TPathPrivilege>();
        ArrayList<Role> roleList1 = new ArrayList<Role>();
        roleList1.add(role1);
        roleList1.add(role2);
        for (Object pathPrivilege : user.getPathPrivilegeList()) {
            TPathPrivilege pathPri = new TPathPrivilege();
            pathPri.setPath(pathPrivilege.getPath().getFullPath());
            pathPri.setPriSet(pathPrivilege.getPrivileges());
            pathPri.setPriGrantOpt(pathPrivilege.getGrantOpt());
            userPrivilegeList.add(pathPri);
        }
        tUserResp.setUsername(user.getName());
        tUserResp.setPassword(user.getPassword());
        tUserResp.setPrivilegeList(userPrivilegeList);
        tUserResp.setSysPriSet(user.getSysPrivilege());
        tUserResp.setRoleList(new ArrayList());
        result.setUserInfo(tUserResp);
        result.setRoleInfo(new HashMap());
        this.authorityFetcher.getAuthorCache().putUserCache(user.getName(), this.authorityFetcher.cacheUser(result));
        User user1 = this.authorityFetcher.getAuthorCache().getUserCache(user.getName());
        assert (user1 != null);
        Assert.assertEquals((Object)user.getName(), (Object)user1.getName());
        Assert.assertEquals((Object)user.getPassword(), (Object)user1.getPassword());
        Assert.assertEquals((Object)user.getPathPrivilegeList(), (Object)user1.getPathPrivilegeList());
        Assert.assertEquals((Object)user.getSysPrivilege(), (Object)user1.getSysPrivilege());
        Assert.assertEquals((long)this.authorityFetcher.checkUserPathPrivileges("user", Collections.singletonList(new PartialPath("root.ln")), PrivilegeType.READ_DATA.ordinal()).size(), (long)0L);
        Assert.assertEquals((long)this.authorityFetcher.checkUserPathPrivileges("user", Collections.singletonList(new PartialPath("root.ln")), PrivilegeType.WRITE_DATA.ordinal()).size(), (long)1L);
        this.authorityFetcher.getAuthorCache().invalidateCache(user.getName(), "");
        tUserResp.setPrivilegeList(new ArrayList());
        tUserResp.setRoleList(user.getRoleList());
        for (Role role : roleList1) {
            TRoleResp tRoleResp = new TRoleResp();
            rolePrivilegeList = new ArrayList();
            tRoleResp.setRoleName(role.getName());
            for (PathPrivilege pathPrivilege : role.getPathPrivilegeList()) {
                TPathPrivilege pathPri = new TPathPrivilege();
                pathPri.setPath(pathPrivilege.getPath().getFullPath());
                pathPri.setPriSet(pathPrivilege.getPrivileges());
                pathPri.setPriGrantOpt(pathPrivilege.getGrantOpt());
                rolePrivilegeList.add(pathPri);
            }
            tRoleResp.setPrivilegeList(rolePrivilegeList);
            tRoleRespMap.put(role.getName(), tRoleResp);
        }
        result.setRoleInfo(tRoleRespMap);
        this.authorityFetcher.getAuthorCache().putUserCache(user.getName(), this.authorityFetcher.cacheUser(result));
        Role role3 = this.authorityFetcher.getAuthorCache().getRoleCache(role1.getName());
        Assert.assertEquals((Object)role1.getName(), (Object)role3.getName());
        Assert.assertEquals((Object)role1.getPathPrivilegeList(), (Object)role3.getPathPrivilegeList());
        Assert.assertEquals((long)this.authorityFetcher.checkUserPathPrivileges("user", Collections.singletonList(new PartialPath("root.ln")), PrivilegeType.READ_DATA.ordinal()).size(), (long)0L);
        Assert.assertEquals((long)this.authorityFetcher.checkUserPathPrivileges("user", Collections.singletonList(new PartialPath("root.ln")), PrivilegeType.MANAGE_USER.ordinal()).size(), (long)1L);
        this.authorityFetcher.getAuthorCache().invalidateCache(user.getName(), "");
        user1 = this.authorityFetcher.getAuthorCache().getUserCache(user.getName());
        role1 = this.authorityFetcher.getAuthorCache().getRoleCache(role1.getName());
        Assert.assertNull((Object)user1);
        Assert.assertNull((Object)role1);
    }

    @Test
    public void grantOptTest() throws IllegalPathException {
        User user = new User();
        Role role = new Role();
        HashSet<Integer> sysPri = new HashSet<Integer>();
        sysPri.add(PrivilegeType.MANAGE_DATABASE.ordinal());
        sysPri.add(PrivilegeType.USE_PIPE.ordinal());
        user.setSysPrivilegeSet(sysPri);
        HashSet<Integer> sysGrantOpt = new HashSet<Integer>();
        sysGrantOpt.add(PrivilegeType.USE_PIPE.ordinal());
        user.setSysPriGrantOpt(sysGrantOpt);
        ArrayList<PathPrivilege> pathList = new ArrayList<PathPrivilege>();
        PartialPath pathRoot = new PartialPath("root.**");
        PartialPath path1 = new PartialPath("root.d1.**");
        PathPrivilege priv1 = new PathPrivilege(path1);
        priv1.grantPrivilege(PrivilegeType.READ_DATA.ordinal(), false);
        priv1.grantPrivilege(PrivilegeType.WRITE_SCHEMA.ordinal(), true);
        pathList.add(priv1);
        user.setPrivilegeList(pathList);
        user.setName("user1");
        user.setPassword("123456");
        role.setName("role1");
        HashSet<Integer> sysPriRole = new HashSet<Integer>();
        sysPriRole.add(PrivilegeType.USE_UDF.ordinal());
        sysPriRole.add(PrivilegeType.USE_CQ.ordinal());
        role.setSysPrivilegeSet(sysPriRole);
        HashSet<Integer> sysGrantOptRole = new HashSet<Integer>();
        sysGrantOptRole.add(PrivilegeType.USE_CQ.ordinal());
        role.setSysPriGrantOpt(sysGrantOptRole);
        PathPrivilege privRole = new PathPrivilege(new PartialPath("root.t9.**"));
        privRole.grantPrivilege(PrivilegeType.READ_DATA.ordinal(), true);
        role.setPrivilegeList(Collections.singletonList(privRole));
        user.setRoleList(Collections.singletonList("role1"));
        this.authorityFetcher.getAuthorCache().putUserCache("user1", user);
        this.authorityFetcher.getAuthorCache().putRoleCache("role1", role);
        Assert.assertTrue((boolean)this.authorityFetcher.checkUserPrivilegeGrantOpt("user1", Collections.singletonList(pathRoot), PrivilegeType.USE_PIPE.ordinal()));
        Assert.assertFalse((boolean)this.authorityFetcher.checkUserPrivilegeGrantOpt("user1", Collections.singletonList(pathRoot), PrivilegeType.MANAGE_USER.ordinal()));
        Assert.assertTrue((boolean)this.authorityFetcher.checkUserPrivilegeGrantOpt("user1", Collections.singletonList(path1), PrivilegeType.WRITE_SCHEMA.ordinal()));
        Assert.assertFalse((boolean)this.authorityFetcher.checkUserPrivilegeGrantOpt("user1", Collections.singletonList(pathRoot), PrivilegeType.WRITE_SCHEMA.ordinal()));
        Assert.assertTrue((boolean)this.authorityFetcher.checkUserPrivilegeGrantOpt("user1", Collections.singletonList(new PartialPath(new String("root.d1.d2"))), PrivilegeType.WRITE_SCHEMA.ordinal()));
        Assert.assertFalse((boolean)this.authorityFetcher.checkUserPrivilegeGrantOpt("user1", Collections.singletonList(new PartialPath(new String("root.d1.d2"))), PrivilegeType.READ_SCHEMA.ordinal()));
        Assert.assertTrue((boolean)this.authorityFetcher.checkUserPrivilegeGrantOpt("user1", Collections.singletonList(new PartialPath(new String("root.t9.**"))), PrivilegeType.READ_DATA.ordinal()));
        Assert.assertTrue((boolean)this.authorityFetcher.checkUserPrivilegeGrantOpt("user1", Collections.singletonList(new PartialPath(new String("root.t9.t10"))), PrivilegeType.READ_DATA.ordinal()));
        Assert.assertFalse((boolean)this.authorityFetcher.checkUserPrivilegeGrantOpt("user1", Collections.singletonList(new PartialPath(new String("root.t9.**"))), PrivilegeType.WRITE_DATA.ordinal()));
        Assert.assertFalse((boolean)this.authorityFetcher.checkUserPrivilegeGrantOpt("user1", Collections.singletonList(pathRoot), PrivilegeType.USE_TRIGGER.ordinal()));
        Assert.assertTrue((boolean)this.authorityFetcher.checkUserPrivilegeGrantOpt("user1", Collections.singletonList(pathRoot), PrivilegeType.USE_CQ.ordinal()));
    }
}

