
package org.apache.iotdb.db.queryengine.execution.operator.window;

import org.apache.iotdb.tsfile.read.common.block.column.Column;

public class VariationFloatWindow extends AbstractVariationFloatWindow {

  public VariationFloatWindow(VariationWindowParameter variationWindowParameter) {
    super(variationWindowParameter);
  }

  @Override
  public boolean satisfy(Column column, int index) {
    if (!initializedHeadValue) {
      return true;
    }
    if(column.isNull(index)){
      return valueIsNull;
    }
    return !valueIsNull&&Math.abs(column.getFloat(index) - headValue) <= getDelta();
  }
}



