package org.apache.iotdb.db.queryengine.execution.operator.process.fill.previous;

import org.apache.iotdb.db.queryengine.execution.operator.process.fill.IFill;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.IFillFilter;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.FloatColumn;
import org.apache.iotdb.tsfile.read.common.block.column.FloatColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;

import java.util.Optional;

/*
* This class is generated using freemarker and the previousFill.ftl template.
*/
@SuppressWarnings("unused")
public class FloatPreviousFill implements IFill {

  // previous value
  private float value;
  // previous time
  private long previousTime;
  // whether previous value is null
  private boolean previousIsNull = true;

  private final IFillFilter filter;

  public FloatPreviousFill(IFillFilter filter) {
    this.filter = filter;
  }

  @Override
  public Column fill(TimeColumn timeColumn, Column valueColumn) {
    int size = valueColumn.getPositionCount();
    // if this valueColumn is empty, just return itself;
    if (size == 0) {
      return valueColumn;
    }
    // if this valueColumn doesn't have any null value, record the last value, and then return
    // itself.
    if (!valueColumn.mayHaveNull()) {
      previousIsNull = false;
      // update the value using last non-null value
      previousTime = timeColumn.getLong(size - 1);
      value = valueColumn.getFloat(size - 1);
      return valueColumn;
    }
    // if its values are all null
    if (valueColumn instanceof RunLengthEncodedColumn) {
      if (previousIsNull) {
        return new RunLengthEncodedColumn(FloatColumnBuilder.NULL_VALUE_BLOCK, size);
      } else if (filter.needFill(timeColumn.getLong(size - 1), previousTime)) {
        return new RunLengthEncodedColumn(
            new FloatColumn(1, Optional.empty(), new float[] {value}), size);
      }
    }

    float[] array = new float[size];
    boolean[] isNull = new boolean[size];
    // have null value
    boolean hasNullValue = false;
    for (int i = 0; i < size; i++) {
      if (valueColumn.isNull(i)) {
        if (previousIsNull || !filter.needFill(timeColumn.getLong(i), previousTime)) {
          isNull[i] = true;
          hasNullValue = true;
        } else {
          array[i] = value;
        }
      } else {
        array[i] = valueColumn.getFloat(i);
        previousTime = timeColumn.getLong(i);
        value = array[i];
        previousIsNull = false;
      }
    }
    if (hasNullValue) {
      return new FloatColumn(size, Optional.of(isNull), array);
    } else {
      return new FloatColumn(size, Optional.empty(), array);
    }
  }
}

