package org.apache.iotdb.db.queryengine.execution.operator.process.fill.linear;

import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.LongColumn;
import org.apache.iotdb.tsfile.read.common.block.column.LongColumnBuilder;

import java.util.Optional;

/*
* This class is generated using freemarker and the linearFill.ftl template.
*/
@SuppressWarnings("unused")
public class LongLinearFill extends LinearFill {

  // previous value
  private long previousValue;
  // next non-null value whose time is closest to the current TsBlock's endTime
  private long nextValue;

  private long nextValueInCurrentColumn;

  @Override
  void fillValue(Column column, int index, Object array) {
    ((long[]) array)[index] = column.getLong(index);
  }

  @Override
  void fillValue(Object array, int index) {
    ((long[]) array)[index] = getFilledValue();
  }

  @Override
  Object createValueArray(int size) {
    return new long[size];
  }

  @Override
  Column createNullValueColumn() {
    return LongColumnBuilder.NULL_VALUE_BLOCK;
  }

  @Override
  Column createFilledValueColumn() {
    long filledValue = getFilledValue();
    return new LongColumn(1, Optional.empty(), new long[] {filledValue});
  }

  @Override
  Column createFilledValueColumn(Object array, boolean[] isNull, boolean hasNullValue, int size) {
    if (hasNullValue) {
      return new LongColumn(size, Optional.of(isNull), (long[]) array);
    } else {
      return new LongColumn(size, Optional.empty(), (long[]) array);
    }
  }

  @Override
  void updatePreviousValue(Column column, int index) {
    previousValue = column.getLong(index);
  }

  @Override
  void updateNextValue(Column nextValueColumn, int index) {
    this.nextValue = nextValueColumn.getLong(index);
  }

  @Override
  void updateNextValueInCurrentColumn(Column nextValueColumn, int index) {
    this.nextValueInCurrentColumn = nextValueColumn.getLong(index);
  }

  @Override
  void updateNextValueInCurrentColumn() {
    this.nextValueInCurrentColumn = this.nextValue;
  }

  private long getFilledValue() {
    return (previousValue + nextValueInCurrentColumn) / 2;
  }
}


