package org.apache.iotdb.db.queryengine.execution.operator.process.fill.constant;

import org.apache.iotdb.db.queryengine.execution.operator.process.fill.IFill;
import org.apache.iotdb.tsfile.read.common.block.column.DoubleColumn;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;

import java.util.Optional;

/*
* This class is generated using freemarker and the constantFill.ftl template.
*/
@SuppressWarnings("unused")
public class DoubleConstantFill implements IFill {

  // fill value
  private final double value;
  // used for constructing RunLengthEncodedColumn, size of it must be 1
  private final double[] valueArray;

  public DoubleConstantFill(double value) {
    this.value = value;
    this.valueArray = new double[] {value};
  }

  @Override
  public Column fill(TimeColumn timeColumn, Column valueColumn) {
    int size = valueColumn.getPositionCount();
    // if this valueColumn doesn't have any null value, or it's empty, just return itself;
    if (!valueColumn.mayHaveNull() || size == 0) {
      return valueColumn;
    }
    // if its values are all null
    if (valueColumn instanceof RunLengthEncodedColumn) {
      return new RunLengthEncodedColumn(new DoubleColumn(1, Optional.empty(), valueArray), size);
    } else {
      double[] array = new double[size];
      for (int i = 0; i < size; i++) {
        if (valueColumn.isNull(i)) {
          array[i] = value;
        } else {
          array[i] = valueColumn.getDouble(i);
        }
      }
      return new DoubleColumn(size, Optional.empty(), array);
    }
  }
}


