package org.apache.iotdb.db.queryengine.execution.operator.process.fill.constant;

import org.apache.iotdb.db.queryengine.execution.operator.process.fill.IFill;
import org.apache.iotdb.tsfile.read.common.block.column.BooleanColumn;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;

import java.util.Optional;

/*
* This class is generated using freemarker and the constantFill.ftl template.
*/
@SuppressWarnings("unused")
public class BooleanConstantFill implements IFill {

  // fill value
  private final boolean value;
  // used for constructing RunLengthEncodedColumn, size of it must be 1
  private final boolean[] valueArray;

  public BooleanConstantFill(boolean value) {
    this.value = value;
    this.valueArray = new boolean[] {value};
  }

  @Override
  public Column fill(TimeColumn timeColumn, Column valueColumn) {
    int size = valueColumn.getPositionCount();
    // if this valueColumn doesn't have any null value, or it's empty, just return itself;
    if (!valueColumn.mayHaveNull() || size == 0) {
      return valueColumn;
    }
    // if its values are all null
    if (valueColumn instanceof RunLengthEncodedColumn) {
      return new RunLengthEncodedColumn(new BooleanColumn(1, Optional.empty(), valueArray), size);
    } else {
      boolean[] array = new boolean[size];
      for (int i = 0; i < size; i++) {
        if (valueColumn.isNull(i)) {
          array[i] = value;
        } else {
          array[i] = valueColumn.getBoolean(i);
        }
      }
      return new BooleanColumn(size, Optional.empty(), array);
    }
  }
}


