package org.apache.iotdb.db.queryengine.execution.operator.process.fill.constant;

import org.apache.iotdb.db.queryengine.execution.operator.process.fill.IFill;
import org.apache.iotdb.tsfile.read.common.block.column.BinaryColumn;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.utils.Binary;

import java.util.Optional;

/*
* This class is generated using freemarker and the constantFill.ftl template.
*/
@SuppressWarnings("unused")
public class BinaryConstantFill implements IFill {

  // fill value
  private final Binary value;
  // used for constructing RunLengthEncodedColumn, size of it must be 1
  private final Binary[] valueArray;

  public BinaryConstantFill(Binary value) {
    this.value = value;
    this.valueArray = new Binary[] {value};
  }

  @Override
  public Column fill(TimeColumn timeColumn, Column valueColumn) {
    int size = valueColumn.getPositionCount();
    // if this valueColumn doesn't have any null value, or it's empty, just return itself;
    if (!valueColumn.mayHaveNull() || size == 0) {
      return valueColumn;
    }
    // if its values are all null
    if (valueColumn instanceof RunLengthEncodedColumn) {
      return new RunLengthEncodedColumn(new BinaryColumn(1, Optional.empty(), valueArray), size);
    } else {
      Binary[] array = new Binary[size];
      for (int i = 0; i < size; i++) {
        if (valueColumn.isNull(i)) {
          array[i] = value;
        } else {
          array[i] = valueColumn.getBinary(i);
        }
      }
      return new BinaryColumn(size, Optional.empty(), array);
    }
  }
}

