/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.wal.buffer.WALEntry;
import org.apache.iotdb.db.wal.buffer.WALEntryType;
import org.apache.iotdb.db.wal.exception.WALException;
import org.apache.iotdb.db.wal.utils.WALFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalChecker {
    private static final Logger logger = LoggerFactory.getLogger(WalChecker.class);
    private String walFolder;

    public WalChecker(String walFolder) {
        this.walFolder = walFolder;
    }

    public List<File> doCheck() throws WALException {
        File walFolderFile = SystemFileFactory.INSTANCE.getFile(this.walFolder);
        logger.info("Checking folder: {}", (Object)walFolderFile.getAbsolutePath());
        if (!walFolderFile.exists() || !walFolderFile.isDirectory()) {
            throw new WALException(this.walFolder);
        }
        File[] walNodeFolders = walFolderFile.listFiles(File::isDirectory);
        if (walNodeFolders == null || walNodeFolders.length == 0) {
            logger.info("No sub-directories under the given directory, check ends");
            return Collections.emptyList();
        }
        ArrayList<File> failedFiles = new ArrayList<File>();
        for (int dirIndex = 0; dirIndex < walNodeFolders.length; ++dirIndex) {
            File walNodeFolder = walNodeFolders[dirIndex];
            logger.info("Checking the No.{} directory {}", (Object)dirIndex, (Object)walNodeFolder.getName());
            File[] walFiles = WALFileUtils.listAllWALFiles(walNodeFolder);
            if (walFiles == null) continue;
            for (File walFile : walFiles) {
                if (this.checkFile(walFile)) continue;
                failedFiles.add(walFile);
            }
        }
        return failedFiles;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkFile(File walFile) {
        try (DataInputStream logStream = new DataInputStream(new BufferedInputStream(new FileInputStream(walFile)));){
            WALEntry walEntry;
            do {
                if (logStream.available() <= 0) return true;
            } while ((walEntry = WALEntry.deserialize(logStream)).getType() != WALEntryType.WAL_FILE_INFO_END_MARKER);
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            logger.debug("Wal file doesn't exist, skipping");
            return true;
        }
        catch (IOException | IllegalPathException e) {
            logger.error("{} fails the check because", (Object)walFile, (Object)e);
            return false;
        }
    }

    public static void report(List<File> failedFiles) {
        if (failedFiles.isEmpty()) {
            logger.info("Check finished. There is no damaged file");
        } else {
            logger.error("There are {} failed files. They are {}", (Object)failedFiles.size(), failedFiles);
        }
    }

    public static void main(String[] args) throws WALException {
        if (args.length < 1) {
            logger.error("No enough args: require the walRootDirectory");
            return;
        }
        WalChecker checker = new WalChecker(args[0]);
        List<File> files = checker.doCheck();
        WalChecker.report(files);
    }
}

