/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.engine.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.engine.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.engine.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.wal.WALManager;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Gauge;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.iotdb.metrics.utils.SystemType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMetrics
implements IMetricSet {
    private static final Logger log = LoggerFactory.getLogger(FileMetrics.class);
    private static final MetricConfig METRIC_CONFIG = MetricConfigDescriptor.getInstance().getMetricConfig();
    private static final WALManager WAL_MANAGER = WALManager.getInstance();
    private final Runtime runtime = Runtime.getRuntime();
    private String[] getOpenFileNumberCommand;
    private AbstractMetricService metricService = null;
    private static final String FILE_LEVEL_COUNT = "file_level_count";
    private static final String FILE_LEVEL_SIZE = "file_level_size";
    private static final String SEQUENCE = "sequence";
    private static final String UNSEQUENCE = "unsequence";
    private static final String LEVEL = "level";
    private final AtomicLong seqFileSize = new AtomicLong(0L);
    private final AtomicLong unseqFileSize = new AtomicLong(0L);
    private final AtomicInteger seqFileNum = new AtomicInteger(0);
    private final AtomicInteger unseqFileNum = new AtomicInteger(0);
    private final AtomicInteger modFileNum = new AtomicInteger(0);
    private final AtomicLong modFileSize = new AtomicLong(0L);
    private final Map<Integer, Integer> seqLevelTsFileCountMap = new ConcurrentHashMap<Integer, Integer>();
    private final Map<Integer, Integer> unseqLevelTsFileCountMap = new ConcurrentHashMap<Integer, Integer>();
    private final Map<Integer, Long> seqLevelTsFileSizeMap = new ConcurrentHashMap<Integer, Long>();
    private final Map<Integer, Long> unseqLevelTsFileSizeMap = new ConcurrentHashMap<Integer, Long>();
    private long lastUpdateTime = 0L;
    private final AtomicLong innerSeqCompactionTempFileSize = new AtomicLong(0L);
    private final AtomicLong innerUnseqCompactionTempFileSize = new AtomicLong(0L);
    private final AtomicLong crossCompactionTempFileSize = new AtomicLong(0L);
    private final AtomicInteger innerSeqCompactionTempFileNum = new AtomicInteger(0);
    private final AtomicInteger innerUnseqCompactionTempFileNum = new AtomicInteger(0);
    private final AtomicInteger crossCompactionTempFileNum = new AtomicInteger(0);
    private AtomicBoolean hasRemainData = new AtomicBoolean(false);
    private final Map<Integer, Gauge> seqLevelCountGaugeMap = new ConcurrentHashMap<Integer, Gauge>();
    private final Map<Integer, Gauge> seqLevelSizeGaugeMap = new ConcurrentHashMap<Integer, Gauge>();
    private final Map<Integer, Gauge> unseqLevelCountGaugeMap = new ConcurrentHashMap<Integer, Gauge>();
    private final Map<Integer, Gauge> unseqLevelSizeGaugeMap = new ConcurrentHashMap<Integer, Gauge>();
    private String fileHandlerCntPathInLinux = String.format(this.fileHandlerCntPathInLinux, METRIC_CONFIG.getPid());

    private FileMetrics() {
    }

    public static FileMetrics getInstance() {
        return FileMetricsInstanceHolder.INSTANCE;
    }

    public void bindTo(AbstractMetricService metricService) {
        this.metricService = metricService;
        this.bindTsFileMetrics(metricService);
        this.bindWalFileMetrics(metricService);
        this.bindCompactionFileMetrics(metricService);
        this.bindSystemRelatedMetrics(metricService);
    }

    private void bindTsFileMetrics(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.CORE, (Object)this, o -> o.getFileSize(true), new String[]{Tag.NAME.toString(), "seq"});
        metricService.createAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.CORE, (Object)this, o -> o.getFileSize(false), new String[]{Tag.NAME.toString(), "unseq"});
        metricService.createAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.CORE, (Object)this, FileMetrics::getModFileSize, new String[]{Tag.NAME.toString(), "mods"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.CORE, (Object)this, o -> o.getFileNum(true), new String[]{Tag.NAME.toString(), "seq"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.CORE, (Object)this, o -> o.getFileNum(false), new String[]{Tag.NAME.toString(), "unseq"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.CORE, (Object)this, FileMetrics::getModFileNum, new String[]{Tag.NAME.toString(), "mods"});
        this.checkIfThereRemainingData();
    }

    private void bindWalFileMetrics(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.CORE, (Object)WAL_MANAGER, WALManager::getTotalDiskUsage, new String[]{Tag.NAME.toString(), "wal"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.CORE, (Object)WAL_MANAGER, WALManager::getTotalFileNum, new String[]{Tag.NAME.toString(), "wal"});
    }

    private void bindCompactionFileMetrics(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.CORE, (Object)this, o -> o.getInnerCompactionTempFileSize(true), new String[]{Tag.NAME.toString(), "inner-seq-temp"});
        metricService.createAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.CORE, (Object)this, o -> o.getInnerCompactionTempFileSize(false), new String[]{Tag.NAME.toString(), "inner-unseq-temp"});
        metricService.createAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.CORE, (Object)this, FileMetrics::getCrossCompactionTempFileSize, new String[]{Tag.NAME.toString(), "cross-temp"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.CORE, (Object)this, o -> o.getInnerCompactionTempFileNum(true), new String[]{Tag.NAME.toString(), "inner-seq-temp"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.CORE, (Object)this, o -> o.getInnerCompactionTempFileNum(false), new String[]{Tag.NAME.toString(), "inner-unseq-temp"});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.CORE, (Object)this, FileMetrics::getCrossCompactionTempFileNum, new String[]{Tag.NAME.toString(), "cross-temp"});
    }

    private void bindSystemRelatedMetrics(AbstractMetricService metricService) {
        if ((METRIC_CONFIG.getSystemType() == SystemType.LINUX || METRIC_CONFIG.getSystemType() == SystemType.MAC) && METRIC_CONFIG.getPid().length() != 0) {
            this.getOpenFileNumberCommand = new String[]{"/bin/sh", "-c", String.format("lsof -p %s | wc -l", METRIC_CONFIG.getPid())};
            metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getOpenFileHandlersNumber, new String[]{Tag.NAME.toString(), "open_file_handlers"});
        }
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.unbindTsFileMetrics(metricService);
        this.unbindWalMetrics(metricService);
        this.unbindCompactionMetrics(metricService);
        this.unbindSystemRelatedMetrics(metricService);
    }

    private void unbindTsFileMetrics(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), "seq"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), "unseq"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), "mods"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "seq"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "unseq"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "mods"});
    }

    private void unbindWalMetrics(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), "wal"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "wal"});
    }

    private void unbindCompactionMetrics(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "inner-seq-temp"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "inner-unseq-temp"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "cross-temp"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), "inner-seq-temp"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), "inner-unseq-temp"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), "cross-temp"});
    }

    private void unbindSystemRelatedMetrics(AbstractMetricService metricService) {
        if ((METRIC_CONFIG.getSystemType() == SystemType.LINUX || METRIC_CONFIG.getSystemType() == SystemType.MAC) && METRIC_CONFIG.getPid().length() != 0) {
            metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), "open_file_handlers"});
        }
    }

    private long getOpenFileHandlersNumber() {
        long fdCount;
        block10: {
            fdCount = 0L;
            try {
                if (METRIC_CONFIG.getSystemType() == SystemType.LINUX) {
                    File fdDir = new File(this.fileHandlerCntPathInLinux);
                    if (fdDir.exists()) {
                        File[] fds = fdDir.listFiles();
                        fdCount = fds == null ? 0L : (long)fds.length;
                    }
                    break block10;
                }
                if (METRIC_CONFIG.getSystemType() != SystemType.MAC || METRIC_CONFIG.getPid().length() == 0) break block10;
                Process process = this.runtime.exec(this.getOpenFileNumberCommand);
                StringBuilder result = new StringBuilder();
                try (BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String line;
                    while ((line = input.readLine()) != null) {
                        result.append(line);
                    }
                }
                fdCount = Long.parseLong(result.toString().trim());
            }
            catch (IOException e) {
                log.warn("Failed to get open file number, because ", (Throwable)e);
            }
        }
        return fdCount;
    }

    public void addFile(long size, boolean seq, String name) {
        this.updateGlobalCountAndSize(size, 1, seq);
        try {
            TsFileNameGenerator.TsFileName tsFileName = TsFileNameGenerator.getTsFileName(name);
            int level = tsFileName.getInnerCompactionCnt();
            this.updateLevelCountAndSize(size, 1, seq, level);
        }
        catch (IOException e) {
            log.warn("Unexpected error occurred when getting tsfile name", (Throwable)e);
        }
    }

    private void updateGlobalCountAndSize(long sizeDelta, int countDelta, boolean seq) {
        if (seq) {
            this.seqFileSize.getAndAdd(sizeDelta);
            this.seqFileNum.getAndAdd(countDelta);
        } else {
            this.unseqFileSize.getAndAdd(sizeDelta);
            this.unseqFileNum.getAndAdd(countDelta);
        }
    }

    private void updateLevelCountAndSize(long sizeDelta, int countDelta, boolean seq, int level) {
        int count = 0;
        long totalSize = 0L;
        if (seq) {
            count = this.seqLevelTsFileCountMap.compute(level, (k, v) -> v == null ? countDelta : v + countDelta);
            totalSize = this.seqLevelTsFileSizeMap.compute(level, (k, v) -> v == null ? sizeDelta : v + sizeDelta);
        } else {
            count = this.unseqLevelTsFileCountMap.compute(level, (k, v) -> v == null ? countDelta : v + countDelta);
            totalSize = this.unseqLevelTsFileSizeMap.compute(level, (k, v) -> v == null ? sizeDelta : v + sizeDelta);
        }
        this.updateLevelFileInfoInMetricService(totalSize, count, seq, level);
    }

    private void updateLevelFileInfoInMetricService(long totalSize, int count, boolean seq, int level) {
        if (this.metricService != null) {
            this.updateCountGauge(level, count, seq ? this.seqLevelCountGaugeMap : this.unseqLevelCountGaugeMap, seq ? SEQUENCE : UNSEQUENCE);
            this.updateSizeGauge(level, totalSize, seq ? this.seqLevelSizeGaugeMap : this.unseqLevelSizeGaugeMap, seq ? SEQUENCE : UNSEQUENCE);
            this.checkIfThereRemainingData();
        } else {
            this.hasRemainData.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfThereRemainingData() {
        if (this.hasRemainData.get()) {
            FileMetrics fileMetrics = this;
            synchronized (fileMetrics) {
                if (this.hasRemainData.get()) {
                    this.hasRemainData.set(false);
                    this.updateRemainData();
                }
            }
        }
    }

    private void updateCountGauge(int level, int count, Map<Integer, Gauge> countGaugeMap, String orderStr) {
        countGaugeMap.computeIfAbsent(level, l -> this.metricService.getOrCreateGauge(FILE_LEVEL_COUNT, MetricLevel.CORE, new String[]{Tag.TYPE.toString(), orderStr, LEVEL, String.valueOf(level)})).set((long)count);
    }

    private void updateSizeGauge(int level, long size, Map<Integer, Gauge> sizeGaugeMap, String orderStr) {
        sizeGaugeMap.computeIfAbsent(level, l -> this.metricService.getOrCreateGauge(FILE_LEVEL_SIZE, MetricLevel.CORE, new String[]{Tag.TYPE.toString(), orderStr, LEVEL, String.valueOf(level)})).set(size);
    }

    public void deleteFile(long[] sizeList, boolean seq, List<String> names) {
        long totalSize = 0L;
        for (long size : sizeList) {
            totalSize += size;
        }
        this.updateGlobalCountAndSize(-totalSize, -sizeList.length, seq);
        int length = names.size();
        for (int i = 0; i < length; ++i) {
            int level = -1;
            String name = names.get(i);
            long size = sizeList[i];
            try {
                TsFileNameGenerator.TsFileName tsFileName = TsFileNameGenerator.getTsFileName(name);
                level = tsFileName.getInnerCompactionCnt();
                this.updateLevelCountAndSize(-size, -1, seq, level);
                continue;
            }
            catch (IOException e) {
                log.warn("Unexpected error occurred when getting tsfile name", (Throwable)e);
            }
        }
    }

    private void updateRemainData() {
        for (Map.Entry<Integer, Integer> entry : this.seqLevelTsFileCountMap.entrySet()) {
            this.updateCountGauge(entry.getKey(), entry.getValue(), this.seqLevelCountGaugeMap, SEQUENCE);
        }
        for (Map.Entry<Integer, Number> entry : this.seqLevelTsFileSizeMap.entrySet()) {
            this.updateSizeGauge(entry.getKey(), (Long)entry.getValue(), this.seqLevelSizeGaugeMap, SEQUENCE);
        }
        for (Map.Entry<Integer, Number> entry : this.unseqLevelTsFileCountMap.entrySet()) {
            this.updateCountGauge(entry.getKey(), (Integer)entry.getValue(), this.unseqLevelCountGaugeMap, UNSEQUENCE);
        }
        for (Map.Entry<Integer, Number> entry : this.unseqLevelTsFileSizeMap.entrySet()) {
            this.updateSizeGauge(entry.getKey(), (Long)entry.getValue(), this.unseqLevelSizeGaugeMap, UNSEQUENCE);
        }
    }

    public long getFileSize(boolean seq) {
        return seq ? this.seqFileSize.get() : this.unseqFileSize.get();
    }

    public long getFileNum(boolean seq) {
        return seq ? (long)this.seqFileNum.get() : (long)this.unseqFileNum.get();
    }

    public int getModFileNum() {
        return this.modFileNum.get();
    }

    public long getModFileSize() {
        return this.modFileSize.get();
    }

    public void increaseModFileNum(int num) {
        this.modFileNum.addAndGet(num);
    }

    public void decreaseModFileNum(int num) {
        this.modFileNum.addAndGet(-num);
    }

    public void increaseModFileSize(long size) {
        this.modFileSize.addAndGet(size);
    }

    public void decreaseModFileSize(long size) {
        this.modFileSize.addAndGet(-size);
    }

    public long getInnerCompactionTempFileSize(boolean seq) {
        this.updateCompactionTempSize();
        return seq ? this.innerSeqCompactionTempFileSize.get() : this.innerUnseqCompactionTempFileSize.get();
    }

    private synchronized void updateCompactionTempSize() {
        if (System.currentTimeMillis() - this.lastUpdateTime <= 10000L) {
            return;
        }
        this.lastUpdateTime = System.currentTimeMillis();
        this.innerSeqCompactionTempFileSize.set(0L);
        this.innerSeqCompactionTempFileNum.set(0);
        this.innerUnseqCompactionTempFileSize.set(0L);
        this.innerUnseqCompactionTempFileNum.set(0);
        this.crossCompactionTempFileSize.set(0L);
        this.crossCompactionTempFileNum.set(0);
        List<AbstractCompactionTask> runningTasks = CompactionTaskManager.getInstance().getRunningCompactionTaskList();
        for (AbstractCompactionTask task : runningTasks) {
            CompactionTaskSummary summary = task.getSummary();
            if (task instanceof InnerSpaceCompactionTask) {
                if (task.isInnerSeqTask()) {
                    this.innerSeqCompactionTempFileSize.addAndGet(summary.getTemporalFileSize());
                    this.innerSeqCompactionTempFileNum.addAndGet(1);
                    continue;
                }
                this.innerUnseqCompactionTempFileSize.addAndGet(summary.getTemporalFileSize());
                this.innerUnseqCompactionTempFileNum.addAndGet(1);
                continue;
            }
            this.crossCompactionTempFileSize.addAndGet(summary.getTemporalFileSize());
            this.crossCompactionTempFileNum.addAndGet(summary.getTemporalFileNum());
        }
    }

    public long getCrossCompactionTempFileSize() {
        this.updateCompactionTempSize();
        return this.crossCompactionTempFileSize.get();
    }

    public long getInnerCompactionTempFileNum(boolean seq) {
        this.updateCompactionTempSize();
        return seq ? (long)this.innerSeqCompactionTempFileNum.get() : (long)this.innerUnseqCompactionTempFileNum.get();
    }

    public long getCrossCompactionTempFileNum() {
        this.updateCompactionTempSize();
        return this.crossCompactionTempFileNum.get();
    }

    private static class FileMetricsInstanceHolder {
        private static final FileMetrics INSTANCE = new FileMetrics();

        private FileMetricsInstanceHolder() {
        }
    }
}

