/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.quotas;

import org.apache.iotdb.db.quotas.RateLimiter;

public class FixedIntervalRateLimiter
extends RateLimiter {
    private long nextRefillTime = -1L;

    @Override
    public long refill(long limit) {
        long now = System.currentTimeMillis();
        if (now < this.nextRefillTime) {
            return 0L;
        }
        this.nextRefillTime = now + super.getTimeUnitInMillis();
        return limit;
    }

    @Override
    public long getWaitInterval(long limit, long available, long amount) {
        if (this.nextRefillTime == -1L) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        long refillTime = this.nextRefillTime;
        return refillTime - now;
    }

    public long getNextRefillTime() {
        return this.nextRefillTime;
    }

    public void setNextRefillTime(long nextRefillTime) {
        this.nextRefillTime = nextRefillTime;
    }
}

