/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.quotas;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.commons.exception.RpcThrottlingException;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowsOfOneDeviceStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.quotas.OperationQuota;
import org.apache.iotdb.db.quotas.QuotaLimiter;
import org.apache.iotdb.db.utils.TypeInferenceUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.BitMap;

public class DefaultOperationQuota
implements OperationQuota {
    protected final QuotaLimiter limiter;
    protected long readAvailable = 0L;
    protected long writeConsumed = 0L;
    protected long readConsumed = 0L;
    private long[] operationSize;
    protected long writeDiff = 0L;
    protected long readDiff = 0L;

    public DefaultOperationQuota(QuotaLimiter limiter) {
        this.limiter = limiter;
        int size = OperationQuota.OperationType.values().length;
        this.operationSize = new long[size];
        for (int i = 0; i < size; ++i) {
            this.operationSize[i] = 0L;
        }
    }

    @Override
    public void checkQuota(int numWrites, int numReads, Statement s) throws RpcThrottlingException {
        this.updateEstimateConsumeQuota(numWrites, numReads, s);
        this.readAvailable = Long.MAX_VALUE;
        this.limiter.checkQuota(numWrites, this.writeConsumed, numReads, this.readConsumed);
        this.readAvailable = Math.min(this.readAvailable, this.limiter.getReadAvailable());
        this.limiter.grabQuota(numWrites, this.writeConsumed, numReads, this.readConsumed);
    }

    @Override
    public void addReadResult(List<ByteBuffer> queryResult) {
        if (queryResult == null) {
            return;
        }
        long size = 0L;
        for (ByteBuffer buffer : queryResult) {
            size += (long)buffer.limit();
        }
        int n = OperationQuota.OperationType.READ.ordinal();
        this.operationSize[n] = this.operationSize[n] + size;
    }

    protected void updateEstimateConsumeQuota(int numWrites, int numReads, Statement s) {
        if (numWrites > 0) {
            long avgSize = 0L;
            switch (s.getType()) {
                case INSERT: {
                    if (s instanceof InsertStatement) {
                        InsertStatement insertStatement = (InsertStatement)s;
                        for (int i = 0; i < insertStatement.getValuesList().size(); ++i) {
                            avgSize += this.calculationWrite(insertStatement.getValuesList().get(i));
                        }
                    }
                    if (!(s instanceof InsertRowStatement)) break;
                    InsertRowStatement insertRowStatement = (InsertRowStatement)s;
                    avgSize += this.calculationWrite(insertRowStatement.getValues());
                    break;
                }
                case BATCH_INSERT: {
                    InsertTabletStatement insertTabletStatement = (InsertTabletStatement)s;
                    for (BitMap bitMap : insertTabletStatement.getBitMaps()) {
                        avgSize += (long)bitMap.getSize();
                    }
                    break;
                }
                case BATCH_INSERT_ONE_DEVICE: {
                    InsertRowsOfOneDeviceStatement insertRowsOfOneDeviceStatement = (InsertRowsOfOneDeviceStatement)s;
                    for (InsertRowStatement insertRowStatement : insertRowsOfOneDeviceStatement.getInsertRowStatementList()) {
                        avgSize += this.calculationWrite(insertRowStatement.getValues());
                    }
                    break;
                }
                case BATCH_INSERT_ROWS: {
                    InsertRowsStatement insertRowsStatement = (InsertRowsStatement)s;
                    for (InsertRowStatement insertRowStatement : insertRowsStatement.getInsertRowStatementList()) {
                        avgSize += this.calculationWrite(insertRowStatement.getValues());
                    }
                    break;
                }
                case MULTI_BATCH_INSERT: {
                    int i;
                    if (s instanceof LoadTsFileStatement) {
                        LoadTsFileStatement loadTsFileStatement = (LoadTsFileStatement)s;
                        for (i = 0; i < loadTsFileStatement.getResources().size(); ++i) {
                            avgSize += loadTsFileStatement.getResources().get(i).getTsFileSize();
                        }
                    }
                    if (!(s instanceof InsertMultiTabletsStatement)) break;
                    InsertMultiTabletsStatement insertMultiTabletsStatement = (InsertMultiTabletsStatement)s;
                    for (i = 0; i < insertMultiTabletsStatement.getInsertTabletStatementList().size(); ++i) {
                        for (BitMap bitMap : insertMultiTabletsStatement.getInsertTabletStatementList().get(i).getBitMaps()) {
                            avgSize += (long)bitMap.getSize();
                        }
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid statement type: " + (Object)((Object)s.getType()));
                }
            }
            this.writeConsumed = this.estimateConsume(numWrites, avgSize);
        }
        if (numReads > 0) {
            this.readConsumed = this.estimateConsume(numReads, 1000L);
        }
    }

    private long calculationWrite(Object[] values) {
        long size = 0L;
        for (int i = 0; i < values.length; ++i) {
            TSDataType dataType = TypeInferenceUtils.getPredictedDataType(values[i], true);
            assert (dataType != null);
            size += (long)dataType.getDataTypeSize();
        }
        return size;
    }

    private long estimateConsume(int numReqs, long avgSize) {
        if (numReqs > 0) {
            return avgSize * (long)numReqs;
        }
        return 0L;
    }

    @Override
    public void close() {
        this.readDiff = this.operationSize[OperationQuota.OperationType.READ.ordinal()] - this.readConsumed;
        if (this.readDiff != 0L) {
            this.limiter.consumeRead(this.readDiff);
        }
    }
}

