/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunk.metadata;

import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.mpp.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.reader.chunk.DiskChunkLoader;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.controller.IChunkMetadataLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskChunkMetadataLoader
implements IChunkMetadataLoader {
    private final TsFileResource resource;
    private final PartialPath seriesPath;
    private final QueryContext context;
    private final Filter filter;
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static final SeriesScanCostMetricSet SERIES_SCAN_COST_METRIC_SET = SeriesScanCostMetricSet.getInstance();

    public DiskChunkMetadataLoader(TsFileResource resource, PartialPath seriesPath, QueryContext context, Filter filter) {
        this.resource = resource;
        this.seriesPath = seriesPath;
        this.context = context;
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IChunkMetadata> loadChunkMetadataList(ITimeSeriesMetadata timeSeriesMetadata) {
        long t1 = System.nanoTime();
        try {
            List chunkMetadataList = ((TimeseriesMetadata)timeSeriesMetadata).getCopiedChunkMetadataList();
            long t2 = System.nanoTime();
            List<Modification> pathModifications = this.context.getPathModifications(this.resource.getModFile(), this.seriesPath);
            if (this.context.isDebug()) {
                DEBUG_LOGGER.info("Modifications size is {} for file Path: {} ", (Object)pathModifications.size(), (Object)this.resource.getTsFilePath());
                pathModifications.forEach(c -> DEBUG_LOGGER.info(c.toString()));
            }
            if (!pathModifications.isEmpty()) {
                ModificationUtils.modifyChunkMetaData(chunkMetadataList, pathModifications);
            }
            if (this.context.isDebug()) {
                DEBUG_LOGGER.info("After modification Chunk meta data list is: ");
                chunkMetadataList.forEach(c -> DEBUG_LOGGER.info(c.toString()));
            }
            SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("chunk_metadata_modification_non_aligned_disk", System.nanoTime() - t2);
            chunkMetadataList.forEach(chunkMetadata -> {
                if (chunkMetadata.needSetChunkLoader()) {
                    chunkMetadata.setFilePath(this.resource.getTsFilePath());
                    chunkMetadata.setClosed(this.resource.isClosed());
                    chunkMetadata.setChunkLoader((IChunkLoader)new DiskChunkLoader(this.context.isDebug()));
                }
            });
            long t3 = System.nanoTime();
            chunkMetadataList.removeIf(chunkMetaData -> this.filter != null && !this.filter.satisfyStartEndTime(chunkMetaData.getStartTime(), chunkMetaData.getEndTime()) || chunkMetaData.getStartTime() > chunkMetaData.getEndTime());
            SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("chunk_metadata_filter_non_aligned_disk", System.nanoTime() - t3);
            for (IChunkMetadata metadata : chunkMetadataList) {
                if (metadata.isFromOldTsFile()) continue;
                metadata.setVersion(this.resource.getVersion());
            }
            if (this.context.isDebug()) {
                DEBUG_LOGGER.info("After removed by filter Chunk meta data list is: ");
                chunkMetadataList.forEach(c -> DEBUG_LOGGER.info(c.toString()));
            }
            List list = chunkMetadataList;
            return list;
        }
        finally {
            SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("load_chunk_metadata_list_non_aligned_disk", System.nanoTime() - t1);
        }
    }
}

