/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunk;

import java.io.IOException;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.mpp.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IChunkReader;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;

public class DiskChunkLoader
implements IChunkLoader {
    private final boolean debug;
    private static final SeriesScanCostMetricSet SERIES_SCAN_COST_METRIC_SET = SeriesScanCostMetricSet.getInstance();

    public DiskChunkLoader(boolean debug) {
        this.debug = debug;
    }

    public Chunk loadChunk(ChunkMetadata chunkMetaData) throws IOException {
        return ChunkCache.getInstance().get(chunkMetaData, this.debug);
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChunkReader getChunkReader(IChunkMetadata chunkMetaData, Filter timeFilter) throws IOException {
        long t1 = System.nanoTime();
        try {
            Chunk chunk = ChunkCache.getInstance().get((ChunkMetadata)chunkMetaData, this.debug);
            chunk.setFromOldFile(chunkMetaData.isFromOldTsFile());
            long t2 = System.nanoTime();
            ChunkReader chunkReader = new ChunkReader(chunk, timeFilter);
            SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("init_chunk_reader_non_aligned_disk", System.nanoTime() - t2);
            ChunkReader chunkReader2 = chunkReader;
            return chunkReader2;
        }
        finally {
            SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("construct_chunk_reader_non_aligned_disk", System.nanoTime() - t1);
        }
    }
}

