/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.v2.handler;

import java.io.IOException;
import javax.ws.rs.core.Response;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.DatabaseNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.exception.sql.StatementAnalyzeException;
import org.apache.iotdb.db.protocol.rest.model.ExecutionStatus;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionHandler.class);

    private ExceptionHandler() {
    }

    public static ExecutionStatus tryCatchException(Exception e) {
        ExecutionStatus responseResult = new ExecutionStatus();
        if (e instanceof QueryProcessException) {
            responseResult.setMessage(e.getMessage());
            responseResult.setCode(Integer.valueOf(((QueryProcessException)((Object)e)).getErrorCode()));
        } else if (e instanceof DatabaseNotSetException) {
            responseResult.setMessage(e.getMessage());
            responseResult.setCode(Integer.valueOf(((DatabaseNotSetException)((Object)e)).getErrorCode()));
        } else if (e instanceof StorageEngineException) {
            responseResult.setMessage(e.getMessage());
            responseResult.setCode(Integer.valueOf(((StorageEngineException)((Object)e)).getErrorCode()));
        } else if (e instanceof AuthException) {
            responseResult.setMessage(e.getMessage());
            responseResult.setCode(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()));
        } else if (e instanceof IllegalPathException) {
            responseResult.setMessage(e.getMessage());
            responseResult.setCode(Integer.valueOf(((IllegalPathException)((Object)e)).getErrorCode()));
        } else if (e instanceof MetadataException) {
            responseResult.setMessage(e.getMessage());
            responseResult.setCode(Integer.valueOf(((MetadataException)((Object)e)).getErrorCode()));
        } else if (e instanceof IoTDBException) {
            responseResult.setMessage(e.getMessage());
            responseResult.setCode(Integer.valueOf(((IoTDBException)((Object)e)).getErrorCode()));
        } else if (e instanceof ParseCancellationException) {
            responseResult.setMessage(e.getMessage());
            responseResult.setCode(Integer.valueOf(TSStatusCode.SQL_PARSE_ERROR.getStatusCode()));
        } else if (e instanceof StatementAnalyzeException) {
            responseResult.setMessage(e.getMessage());
            responseResult.setCode(Integer.valueOf(TSStatusCode.METADATA_ERROR.getStatusCode()));
        } else if (e instanceof SemanticException) {
            responseResult.setMessage(e.getMessage());
            responseResult.setCode(Integer.valueOf(TSStatusCode.SEMANTIC_ERROR.getStatusCode()));
        } else if (!(e instanceof IOException) && !(e instanceof RuntimeException)) {
            responseResult.setMessage(e.getMessage());
            responseResult.setCode(Integer.valueOf(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        } else {
            responseResult.setMessage(e.getMessage());
            responseResult.setCode(Integer.valueOf(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode()));
        }
        LOGGER.warn(e.getMessage(), (Throwable)e);
        return responseResult;
    }
}

