/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.handler;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.protocol.rest.model.ExecutionStatus;
import org.apache.iotdb.rpc.TSStatusCode;

public class AuthorizationHandler {
    public Response checkAuthority(SecurityContext securityContext, Statement statement) {
        String userName = securityContext.getUserPrincipal().getName();
        try {
            if (!AuthorityChecker.checkAuthorization(statement, userName)) {
                return Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.NO_PERMISSION.getStatusCode())).message(TSStatusCode.NO_PERMISSION.name())).build();
            }
        }
        catch (AuthException e) {
            return Response.ok().entity((Object)new ExecutionStatus().message(e.getMessage()).code(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()))).build();
        }
        return null;
    }
}

