/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.parser;

import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.SqlConstant;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.binary.AdditionExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.DivisionExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.EqualToExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.GreaterEqualExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.GreaterThanExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LessEqualExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LessThanExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LogicAndExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LogicOrExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.ModuloExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.MultiplicationExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.NonEqualExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.SubtractionExpression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.LogicNotExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.NegationExpression;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.component.FromComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.ResultColumn;
import org.apache.iotdb.db.mpp.plan.statement.component.WhereCondition;
import org.apache.iotdb.db.protocol.influxdb.statement.InfluxQueryStatement;
import org.apache.iotdb.db.protocol.influxdb.statement.InfluxSelectComponent;
import org.apache.iotdb.db.qp.sql.InfluxDBSqlParser;
import org.apache.iotdb.db.qp.sql.InfluxDBSqlParserBaseVisitor;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class InfluxDBAstVisitor
extends InfluxDBSqlParserBaseVisitor<Statement> {
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();

    public Statement visitSingleStatement(InfluxDBSqlParser.SingleStatementContext ctx) {
        return (Statement)this.visit((ParseTree)ctx.statement());
    }

    public Statement visitSelectStatement(InfluxDBSqlParser.SelectStatementContext ctx) {
        InfluxQueryStatement queryStatement = new InfluxQueryStatement();
        queryStatement.setSelectComponent(this.parseSelectClause(ctx.selectClause()));
        queryStatement.setFromComponent(this.parseFromClause(ctx.fromClause()));
        if (ctx.whereClause() != null) {
            queryStatement.setWhereCondition(this.parseWhereClause(ctx.whereClause()));
        }
        return queryStatement;
    }

    public InfluxSelectComponent parseSelectClause(InfluxDBSqlParser.SelectClauseContext ctx) {
        InfluxSelectComponent influxSelectComponent = new InfluxSelectComponent();
        for (InfluxDBSqlParser.ResultColumnContext resultColumnContext : ctx.resultColumn()) {
            influxSelectComponent.addResultColumn(this.parseResultColumn(resultColumnContext));
        }
        return influxSelectComponent;
    }

    private FromComponent parseFromClause(InfluxDBSqlParser.FromClauseContext fromClause) {
        FromComponent fromComponent = new FromComponent();
        for (InfluxDBSqlParser.NodeNameContext nodeName : fromClause.nodeName()) {
            fromComponent.addPrefixPath(new PartialPath(nodeName.getText(), false));
        }
        return fromComponent;
    }

    private WhereCondition parseWhereClause(InfluxDBSqlParser.WhereClauseContext ctx) {
        return new WhereCondition(this.parsePredicate(ctx.predicate()));
    }

    private ResultColumn parseResultColumn(InfluxDBSqlParser.ResultColumnContext ctx) {
        Expression selectExpression = this.parseExpression(ctx.expression());
        ResultColumn.ColumnType columnType = ExpressionAnalyzer.identifyOutputColumnType(selectExpression, true);
        if (ctx.AS() != null) {
            return new ResultColumn(selectExpression, ctx.identifier().getText(), columnType);
        }
        return new ResultColumn(selectExpression, columnType);
    }

    private Expression parseExpression(InfluxDBSqlParser.ExpressionContext context) {
        if (context.unaryInBracket != null) {
            return this.parseExpression(context.unaryInBracket);
        }
        if (context.unaryAfterSign != null) {
            return context.MINUS() != null ? new NegationExpression(this.parseExpression(context.expression(0))) : this.parseExpression(context.expression(0));
        }
        if (context.leftExpression != null && context.rightExpression != null) {
            Expression leftExpression = this.parseExpression(context.leftExpression);
            Expression rightExpression = this.parseExpression(context.rightExpression);
            if (context.STAR() != null) {
                return new MultiplicationExpression(leftExpression, rightExpression);
            }
            if (context.DIV() != null) {
                return new DivisionExpression(leftExpression, rightExpression);
            }
            if (context.MOD() != null) {
                return new ModuloExpression(leftExpression, rightExpression);
            }
            if (context.PLUS() != null) {
                return new AdditionExpression(leftExpression, rightExpression);
            }
            if (context.MINUS() != null) {
                return new SubtractionExpression(leftExpression, rightExpression);
            }
        }
        if (context.functionName != null) {
            return this.parseFunctionExpression(context);
        }
        if (context.nodeName() != null || context.constant() != null) {
            return new TimeSeriesOperand(new PartialPath(context.nodeName().getText(), false));
        }
        throw new UnsupportedOperationException();
    }

    private Expression parseFunctionExpression(InfluxDBSqlParser.ExpressionContext functionClause) {
        FunctionExpression functionExpression = new FunctionExpression(functionClause.functionName.getText());
        for (InfluxDBSqlParser.ExpressionContext expression : functionClause.expression()) {
            functionExpression.addExpression(this.parseExpression(expression));
        }
        for (InfluxDBSqlParser.FunctionAttributeContext functionAttribute : functionClause.functionAttribute()) {
            functionExpression.addAttribute(InfluxDBAstVisitor.removeStringQuote(functionAttribute.functionAttributeKey.getText()), InfluxDBAstVisitor.removeStringQuote(functionAttribute.functionAttributeValue.getText()));
        }
        return functionExpression;
    }

    private Expression parsePredicate(InfluxDBSqlParser.PredicateContext context) {
        if (context.predicateInBracket != null) {
            return this.parsePredicate(context.predicateInBracket);
        }
        if (context.OPERATOR_NOT() != null) {
            return new LogicNotExpression(this.parsePredicate(context.predicateAfterUnaryOperator));
        }
        if (context.leftPredicate != null && context.rightPredicate != null) {
            Expression leftExpression = this.parsePredicate(context.leftPredicate);
            Expression rightExpression = this.parsePredicate(context.rightPredicate);
            if (context.OPERATOR_GT() != null) {
                return new GreaterThanExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_GTE() != null) {
                return new GreaterEqualExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_LT() != null) {
                return new LessThanExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_LTE() != null) {
                return new LessEqualExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_SEQ() != null) {
                return new EqualToExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_NEQ() != null) {
                return new NonEqualExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_AND() != null) {
                return new LogicAndExpression(leftExpression, rightExpression);
            }
            if (context.OPERATOR_OR() != null) {
                return new LogicOrExpression(leftExpression, rightExpression);
            }
            throw new UnsupportedOperationException();
        }
        if (context.nodeName() != null) {
            return new TimeSeriesOperand(new PartialPath(context.nodeName().getText(), false));
        }
        if (context.time != null) {
            return new TimeSeriesOperand(SqlConstant.TIME_PATH);
        }
        if (context.constant() != null) {
            return this.parseConstantOperand(context.constant());
        }
        throw new UnsupportedOperationException();
    }

    private Expression parseConstantOperand(InfluxDBSqlParser.ConstantContext constantContext) {
        String text = constantContext.getText();
        if (constantContext.BOOLEAN_LITERAL() != null) {
            return new ConstantOperand(TSDataType.BOOLEAN, text);
        }
        if (constantContext.STRING_LITERAL() != null) {
            return new ConstantOperand(TSDataType.TEXT, this.parseStringLiteral(text));
        }
        if (constantContext.INTEGER_LITERAL() != null) {
            return new ConstantOperand(TSDataType.INT64, text);
        }
        if (constantContext.realLiteral() != null) {
            return this.parseRealLiteral(text);
        }
        if (constantContext.dateExpression() != null) {
            return new ConstantOperand(TSDataType.INT64, String.valueOf(InfluxDBAstVisitor.parseDateExpression(constantContext.dateExpression())));
        }
        throw new SemanticException("Unsupported constant operand: " + text);
    }

    private String parseStringLiteral(String src) {
        if (2 <= src.length()) {
            String unWrappedString = src.substring(1, src.length() - 1);
            if (src.charAt(0) == '\"' && src.charAt(src.length() - 1) == '\"') {
                String replaced = unWrappedString.replace("\"\"", "\"");
                return replaced.length() == 0 ? "" : replaced;
            }
            if (src.charAt(0) == '\'' && src.charAt(src.length() - 1) == '\'') {
                String replaced = unWrappedString.replace("''", "'");
                return replaced.length() == 0 ? "" : replaced;
            }
        }
        return src;
    }

    private Expression parseRealLiteral(String value) {
        return new ConstantOperand(CONFIG.getFloatingStringInferType().equals((Object)TSDataType.DOUBLE) ? TSDataType.DOUBLE : TSDataType.FLOAT, value);
    }

    private static String removeStringQuote(String src) {
        if (src.charAt(0) == '\'' && src.charAt(src.length() - 1) == '\'') {
            return src.substring(1, src.length() - 1);
        }
        if (src.charAt(0) == '\"' && src.charAt(src.length() - 1) == '\"') {
            return src.substring(1, src.length() - 1);
        }
        throw new IllegalArgumentException("error format for string with quote:" + src);
    }

    private static Long parseDateExpression(InfluxDBSqlParser.DateExpressionContext ctx) {
        long time = InfluxDBAstVisitor.parseTimeFormat(ctx.getChild(0).getText());
        for (int i = 1; i < ctx.getChildCount(); i += 2) {
            if (ctx.getChild(i).getText().equals("+")) {
                time += DateTimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText());
                continue;
            }
            time -= DateTimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText());
        }
        return time;
    }

    public static long parseTimeFormat(String timestampStr) {
        if (timestampStr == null || timestampStr.trim().equals("")) {
            throw new IllegalArgumentException("input timestamp cannot be empty");
        }
        if (timestampStr.equalsIgnoreCase("now()")) {
            return DateTimeUtils.currentTime();
        }
        throw new IllegalArgumentException(String.format("Input time format %s error. Input like yyyy-MM-dd HH:mm:ss, yyyy-MM-ddTHH:mm:ss or refer to user document for more info.", timestampStr));
    }
}

