/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunction;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunctionValue;
import org.apache.iotdb.db.protocol.influxdb.handler.NewQueryHandler;
import org.apache.iotdb.db.protocol.influxdb.meta.InfluxDBMetaManagerFactory;
import org.apache.iotdb.db.protocol.influxdb.util.FilterUtils;
import org.apache.iotdb.db.protocol.influxdb.util.QueryResultUtils;
import org.apache.iotdb.db.protocol.influxdb.util.StringUtils;
import org.apache.iotdb.db.service.thrift.impl.NewInfluxDBServiceImpl;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.influxdb.dto.QueryResult;

public class TagQueryHandler
extends NewQueryHandler {
    @Override
    public InfluxFunctionValue updateByIoTDBFunc(String database, String measurement, InfluxFunction function, long sessionid) {
        String path = "root." + database + ".measurement." + measurement;
        return this.updateByIoTDBFunc(path, function, sessionid);
    }

    @Override
    public QueryResult queryByConditions(String querySql, String database, String measurement, Map<String, Integer> tagOrders, Map<String, Integer> fieldOrders, long sessionId) {
        TSExecuteStatementResp executeStatementResp = NewInfluxDBServiceImpl.executeStatement(querySql, sessionId);
        return QueryResultUtils.iotdbResultConvertInfluxResult(executeStatementResp, database, measurement, tagOrders, fieldOrders);
    }

    @Override
    public QueryResult queryByConditions(List<IExpression> expressions, String database, String measurement, Map<String, Integer> fieldOrders, Long sessionId) {
        ArrayList<SingleSeriesExpression> fieldExpressions = new ArrayList<SingleSeriesExpression>();
        ArrayList<SingleSeriesExpression> tagExpressions = new ArrayList<SingleSeriesExpression>();
        Map<String, Integer> tagOrders = InfluxDBMetaManagerFactory.getInstance().getTagOrders(database, measurement, sessionId);
        for (IExpression iExpression : expressions) {
            SingleSeriesExpression singleSeriesExpression = (SingleSeriesExpression)iExpression;
            if (tagOrders.containsKey(singleSeriesExpression.getSeriesPath().getFullPath())) {
                tagExpressions.add(singleSeriesExpression);
                continue;
            }
            fieldExpressions.add(singleSeriesExpression);
        }
        StringBuilder curQueryPath = new StringBuilder("root." + database + ".measurement." + measurement);
        for (SingleSeriesExpression singleSeriesExpression : tagExpressions) {
            String tagKey = singleSeriesExpression.getSeriesPath().getFullPath();
            String tagValue = StringUtils.removeQuotation(FilterUtils.getFilterStringValue(singleSeriesExpression.getFilter()));
            curQueryPath.append(".").append(tagKey).append(".").append(tagValue);
        }
        curQueryPath.append(".**");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < fieldExpressions.size(); ++i) {
            SingleSeriesExpression singleSeriesExpression = (SingleSeriesExpression)fieldExpressions.get(i);
            if (i != 0) {
                stringBuilder.append(" and ");
            }
            stringBuilder.append(singleSeriesExpression.getSeriesPath().getFullPath()).append(" ").append(FilterUtils.getFilerSymbol(singleSeriesExpression.getFilter())).append(" ").append(FilterUtils.getFilterStringValue(singleSeriesExpression.getFilter()));
        }
        String realQuerySql = "select * from " + curQueryPath;
        if (stringBuilder.length() != 0) {
            realQuerySql = realQuerySql + " where " + stringBuilder;
        }
        realQuerySql = realQuerySql + " align by device";
        return this.queryByConditions(realQuerySql, database, measurement, tagOrders, fieldOrders, sessionId);
    }
}

