/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.function.aggregator;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunctionValue;
import org.apache.iotdb.db.protocol.influxdb.function.aggregator.InfluxAggregator;
import org.apache.iotdb.db.utils.MathUtils;

public class InfluxSumFunction
extends InfluxAggregator {
    private final List<Double> numbers = new ArrayList<Double>();
    private long sum = 0L;

    public InfluxSumFunction(List<Expression> expressionList) {
        super(expressionList);
    }

    @Override
    public InfluxFunctionValue calculateBruteForce() {
        return new InfluxFunctionValue(this.numbers.isEmpty() ? this.numbers : Double.valueOf(MathUtils.sum(this.numbers)), 0L);
    }

    @Override
    public InfluxFunctionValue calculateByIoTDBFunc() {
        return new InfluxFunctionValue(this.sum, 0L);
    }

    @Override
    public String getFunctionName() {
        return "sum";
    }

    @Override
    public void updateValueBruteForce(InfluxFunctionValue functionValue) {
        Object value = functionValue.getValue();
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("not support this type");
        }
        double tmpValue = ((Number)value).doubleValue();
        this.numbers.add(tmpValue);
    }

    @Override
    public void updateValueIoTDBFunc(InfluxFunctionValue ... functionValues) {
        this.sum = (long)((double)this.sum + (Double)functionValues[0].getValue());
    }
}

