/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.subtask.connector;

import org.apache.iotdb.db.pipe.execution.executor.PipeConnectorSubtaskExecutor;
import org.apache.iotdb.db.pipe.task.connection.BoundedBlockingPendingQueue;
import org.apache.iotdb.db.pipe.task.subtask.connector.PipeConnectorSubtask;
import org.apache.iotdb.pipe.api.event.Event;

public class PipeConnectorSubtaskLifeCycle
implements AutoCloseable {
    private final PipeConnectorSubtaskExecutor executor;
    private final PipeConnectorSubtask subtask;
    private final BoundedBlockingPendingQueue<Event> pendingQueue;
    private int runningTaskCount;
    private int aliveTaskCount;

    public PipeConnectorSubtaskLifeCycle(PipeConnectorSubtaskExecutor executor, PipeConnectorSubtask subtask, BoundedBlockingPendingQueue<Event> pendingQueue) {
        this.executor = executor;
        this.subtask = subtask;
        this.pendingQueue = pendingQueue;
        this.runningTaskCount = 0;
        this.aliveTaskCount = 0;
    }

    public PipeConnectorSubtask getSubtask() {
        return this.subtask;
    }

    public BoundedBlockingPendingQueue<Event> getPendingQueue() {
        return this.pendingQueue;
    }

    public synchronized void register() {
        if (this.aliveTaskCount < 0) {
            throw new IllegalStateException("aliveTaskCount < 0");
        }
        if (this.aliveTaskCount == 0) {
            this.executor.register(this.subtask);
            this.runningTaskCount = 0;
        }
        ++this.aliveTaskCount;
    }

    public synchronized boolean deregister() {
        if (this.aliveTaskCount <= 0) {
            throw new IllegalStateException("aliveTaskCount <= 0");
        }
        if (this.aliveTaskCount == 1) {
            this.close();
            return true;
        }
        --this.aliveTaskCount;
        return false;
    }

    public synchronized void start() {
        if (this.runningTaskCount < 0) {
            throw new IllegalStateException("runningTaskCount < 0");
        }
        if (this.runningTaskCount == 0) {
            this.executor.start(this.subtask.getTaskID());
        }
        ++this.runningTaskCount;
    }

    public synchronized void stop() {
        if (this.runningTaskCount <= 0) {
            throw new IllegalStateException("runningTaskCount <= 0");
        }
        if (this.runningTaskCount == 1) {
            this.executor.stop(this.subtask.getTaskID());
        }
        --this.runningTaskCount;
    }

    @Override
    public synchronized void close() {
        this.executor.deregister(this.subtask.getTaskID());
    }
}

