/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.realtime.matcher;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.extractor.realtime.PipeRealtimeDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.realtime.matcher.PipeDataRegionMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedSchemaPatternMatcher
implements PipeDataRegionMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedSchemaPatternMatcher.class);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Set<PipeRealtimeDataRegionExtractor> extractors = new HashSet<PipeRealtimeDataRegionExtractor>();
    private final Cache<String, Set<PipeRealtimeDataRegionExtractor>> deviceToExtractorsCache = Caffeine.newBuilder().maximumSize((long)PipeConfig.getInstance().getPipeExtractorMatcherCacheSize()).build();

    @Override
    public void register(PipeRealtimeDataRegionExtractor extractor) {
        this.lock.writeLock().lock();
        try {
            this.extractors.add(extractor);
            this.deviceToExtractorsCache.invalidateAll();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void deregister(PipeRealtimeDataRegionExtractor extractor) {
        this.lock.writeLock().lock();
        try {
            this.extractors.remove(extractor);
            this.deviceToExtractorsCache.invalidateAll();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int getRegisterCount() {
        this.lock.readLock().lock();
        try {
            int n = this.extractors.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PipeRealtimeDataRegionExtractor> match(PipeRealtimeEvent event) {
        HashSet<PipeRealtimeDataRegionExtractor> matchedExtractors = new HashSet<PipeRealtimeDataRegionExtractor>();
        this.lock.readLock().lock();
        try {
            if (this.extractors.isEmpty()) {
                HashSet<PipeRealtimeDataRegionExtractor> hashSet = matchedExtractors;
                return hashSet;
            }
            for (Map.Entry<String, String[]> entry : event.getSchemaInfo().entrySet()) {
                String device = entry.getKey();
                String[] measurements = entry.getValue();
                Set extractorsFilteredByDevice = (Set)this.deviceToExtractorsCache.get((Object)device, this::filterExtractorsByDevice);
                if (extractorsFilteredByDevice == null) {
                    LOGGER.warn("Match result NPE when handle device {}", (Object)device);
                    continue;
                }
                if (measurements.length == 0) {
                    matchedExtractors.addAll(extractorsFilteredByDevice);
                } else {
                    extractorsFilteredByDevice.forEach(extractor -> {
                        String pattern = extractor.getPattern();
                        if (pattern.length() <= device.length()) {
                            matchedExtractors.add((PipeRealtimeDataRegionExtractor)extractor);
                        } else {
                            for (String measurement : measurements) {
                                if (measurement == null || pattern.length() != device.length() + measurement.length() + 1 || !pattern.endsWith("." + measurement)) continue;
                                matchedExtractors.add((PipeRealtimeDataRegionExtractor)extractor);
                                break;
                            }
                        }
                    });
                }
                if (matchedExtractors.size() != this.extractors.size()) continue;
                break;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return matchedExtractors;
    }

    private Set<PipeRealtimeDataRegionExtractor> filterExtractorsByDevice(String device) {
        HashSet<PipeRealtimeDataRegionExtractor> filteredExtractors = new HashSet<PipeRealtimeDataRegionExtractor>();
        for (PipeRealtimeDataRegionExtractor extractor : this.extractors) {
            String pattern = extractor.getPattern();
            if ((pattern.length() > device.length() || !device.startsWith(pattern)) && (pattern.length() <= device.length() || !pattern.startsWith(device))) continue;
            filteredExtractors.add(extractor);
        }
        return filteredExtractors;
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.extractors.clear();
            this.deviceToExtractorsCache.invalidateAll();
            this.deviceToExtractorsCache.cleanUp();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

