/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.v1.request;

import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.pipe.connector.IoTDBThriftConnectorRequestVersion;
import org.apache.iotdb.db.pipe.connector.v1.PipeRequestType;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;

public class PipeTransferInsertNodeReq
extends TPipeTransferReq {
    private InsertNode insertNode;

    private PipeTransferInsertNodeReq() {
    }

    public InsertNode getInsertNode() {
        return this.insertNode;
    }

    public Statement constructStatement() {
        if (this.insertNode instanceof InsertRowNode) {
            InsertRowNode node = (InsertRowNode)this.insertNode;
            InsertRowStatement statement = new InsertRowStatement();
            statement.setDevicePath(node.getDevicePath());
            statement.setTime(node.getTime());
            statement.setMeasurements(node.getMeasurements());
            statement.setDataTypes(node.getDataTypes());
            statement.setValues(node.getValues());
            statement.setNeedInferType(node.isNeedInferType());
            statement.setAligned(node.isAligned());
            statement.setMeasurementSchemas(node.getMeasurementSchemas());
            return statement;
        }
        if (this.insertNode instanceof InsertTabletNode) {
            InsertTabletNode node = (InsertTabletNode)this.insertNode;
            InsertTabletStatement statement = new InsertTabletStatement();
            statement.setDevicePath(node.getDevicePath());
            statement.setMeasurements(node.getMeasurements());
            statement.setTimes(node.getTimes());
            statement.setColumns(node.getColumns());
            statement.setBitMaps(node.getBitMaps());
            statement.setRowCount(node.getRowCount());
            statement.setDataTypes(node.getDataTypes());
            statement.setAligned(node.isAligned());
            statement.setMeasurementSchemas(node.getMeasurementSchemas());
            return statement;
        }
        throw new UnsupportedOperationException(String.format("unknown InsertNode type %s when constructing statement from insert node.", this.insertNode));
    }

    public static PipeTransferInsertNodeReq toTPipeTransferReq(InsertNode insertNode) {
        PipeTransferInsertNodeReq req = new PipeTransferInsertNodeReq();
        req.insertNode = insertNode;
        req.version = IoTDBThriftConnectorRequestVersion.VERSION_1.getVersion();
        req.type = PipeRequestType.TRANSFER_INSERT_NODE.getType();
        req.body = insertNode.serializeToByteBuffer();
        return req;
    }

    public static PipeTransferInsertNodeReq fromTPipeTransferReq(TPipeTransferReq transferReq) {
        PipeTransferInsertNodeReq insertNodeReq = new PipeTransferInsertNodeReq();
        insertNodeReq.insertNode = (InsertNode)PlanNodeType.deserialize(transferReq.body);
        insertNodeReq.version = transferReq.version;
        insertNodeReq.type = transferReq.type;
        insertNodeReq.body = transferReq.body;
        return insertNodeReq;
    }
}

