/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.legacy.pipedata;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.pipe.connector.legacy.loader.DeletionLoader;
import org.apache.iotdb.db.pipe.connector.legacy.loader.ILoader;
import org.apache.iotdb.db.pipe.connector.legacy.pipedata.PipeData;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class DeletionPipeData
extends PipeData {
    private String database;
    private Deletion deletion;

    @Override
    public PipeData.PipeDataType getPipeDataType() {
        return PipeData.PipeDataType.DELETION;
    }

    @Override
    public long serialize(DataOutputStream stream) throws IOException {
        return super.serialize(stream) + (long)ReadWriteIOUtils.write((String)this.database, (OutputStream)stream) + this.deletion.serializeWithoutFileOffset(stream);
    }

    @Override
    public void deserialize(DataInputStream stream) throws IOException {
        super.deserialize(stream);
        this.database = ReadWriteIOUtils.readString((InputStream)stream);
        try {
            this.deletion = Deletion.deserializeWithoutFileOffset(stream);
        }
        catch (IllegalPathException e) {
            throw new IOException(e);
        }
    }

    @Override
    public ILoader createLoader() {
        return new DeletionLoader(this.deletion);
    }

    public String toString() {
        return "DeletionData{serialNumber=" + this.serialNumber + ", deletion=" + this.deletion + '}';
    }

    public Deletion getDeletion() {
        return this.deletion;
    }

    public String getDatabase() {
        return this.database;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeletionPipeData that = (DeletionPipeData)o;
        return Objects.equals(this.deletion, that.deletion) && Objects.equals(this.serialNumber, that.serialNumber);
    }

    public int hashCode() {
        return Objects.hash(this.deletion, this.serialNumber);
    }
}

