/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.source;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeUtil;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.LastQueryScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesSourceNode;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class AlignedLastQueryScanNode
extends SeriesSourceNode {
    private final AlignedPath seriesPath;
    private TRegionReplicaSet regionReplicaSet;
    private final String outputViewPath;

    public AlignedLastQueryScanNode(PlanNodeId id, AlignedPath seriesPath, String outputViewPath) {
        super(id);
        this.seriesPath = seriesPath;
        this.outputViewPath = outputViewPath;
    }

    public AlignedLastQueryScanNode(PlanNodeId id, AlignedPath seriesPath, String outputViewPath, TRegionReplicaSet regionReplicaSet) {
        super(id);
        this.seriesPath = seriesPath;
        this.outputViewPath = outputViewPath;
        this.regionReplicaSet = regionReplicaSet;
    }

    public String getOutputViewPath() {
        return this.outputViewPath;
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    @Override
    public void setRegionReplicaSet(TRegionReplicaSet regionReplicaSet) {
        this.regionReplicaSet = regionReplicaSet;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public void addChild(PlanNode child) {
        throw new UnsupportedOperationException("no child is allowed for SeriesScanNode");
    }

    @Override
    public PlanNode clone() {
        return new AlignedLastQueryScanNode(this.getPlanNodeId(), this.seriesPath, this.outputViewPath, this.regionReplicaSet);
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return LastQueryScanNode.LAST_QUERY_HEADER_COLUMNS;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitAlignedLastQueryScan(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlignedLastQueryScanNode that = (AlignedLastQueryScanNode)o;
        return Objects.equals(this.seriesPath, that.seriesPath) && Objects.equals(this.outputViewPath, that.outputViewPath) && Objects.equals(this.regionReplicaSet, that.regionReplicaSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.seriesPath, this.outputViewPath, this.regionReplicaSet);
    }

    public String toString() {
        return String.format("AlignedLastQueryScanNode-%s:[SeriesPath: %s, DataRegion: %s]", this.getPlanNodeId(), this.getSeriesPath().getFormattedString(), PlanNodeUtil.printRegionReplicaSet(this.getRegionReplicaSet()));
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.ALIGNED_LAST_QUERY_SCAN.serialize(byteBuffer);
        this.seriesPath.serialize(byteBuffer);
        ReadWriteIOUtils.write((Boolean)(this.outputViewPath == null ? 1 : 0), (ByteBuffer)byteBuffer);
        if (this.outputViewPath != null) {
            ReadWriteIOUtils.write((String)this.outputViewPath, (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.ALIGNED_LAST_QUERY_SCAN.serialize(stream);
        this.seriesPath.serialize((OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)(this.outputViewPath == null ? 1 : 0), (OutputStream)stream);
        if (this.outputViewPath != null) {
            ReadWriteIOUtils.write((String)this.outputViewPath, (OutputStream)stream);
        }
    }

    public static AlignedLastQueryScanNode deserialize(ByteBuffer byteBuffer) {
        AlignedPath partialPath = (AlignedPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
        boolean isNull = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        String outputPathSymbol = isNull ? null : ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new AlignedLastQueryScanNode(planNodeId, partialPath, outputPathSymbol);
    }

    public AlignedPath getSeriesPath() {
        return this.seriesPath;
    }

    public String getOutputSymbolForSort() {
        if (this.outputViewPath != null) {
            return this.outputViewPath;
        }
        if (this.seriesPath.getMeasurementList().size() > 1) {
            return this.seriesPath.getDevice();
        }
        return this.seriesPath.transformToPartialPath().getFullPath();
    }

    @Override
    public PartialPath getPartitionPath() {
        return this.seriesPath;
    }

    @Override
    public Filter getPartitionTimeFilter() {
        return null;
    }
}

