/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.process;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SlidingWindowAggregationNode
extends SingleChildProcessNode {
    private List<AggregationDescriptor> aggregationDescriptorList;
    private final GroupByTimeParameter groupByTimeParameter;
    protected Ordering scanOrder;

    public SlidingWindowAggregationNode(PlanNodeId id, List<AggregationDescriptor> aggregationDescriptorList, GroupByTimeParameter groupByTimeParameter, Ordering scanOrder) {
        super(id);
        this.aggregationDescriptorList = aggregationDescriptorList;
        this.groupByTimeParameter = groupByTimeParameter;
        this.scanOrder = scanOrder;
    }

    public SlidingWindowAggregationNode(PlanNodeId id, PlanNode child, List<AggregationDescriptor> aggregationDescriptorList, GroupByTimeParameter groupByTimeParameter, Ordering scanOrder) {
        super(id, child);
        this.aggregationDescriptorList = aggregationDescriptorList;
        this.groupByTimeParameter = groupByTimeParameter;
        this.scanOrder = scanOrder;
    }

    public List<AggregationDescriptor> getAggregationDescriptorList() {
        return this.aggregationDescriptorList;
    }

    public void setAggregationDescriptorList(List<AggregationDescriptor> aggregationDescriptorList) {
        this.aggregationDescriptorList = aggregationDescriptorList;
    }

    public GroupByTimeParameter getGroupByTimeParameter() {
        return this.groupByTimeParameter;
    }

    public Ordering getScanOrder() {
        return this.scanOrder;
    }

    @Override
    public PlanNode clone() {
        return new SlidingWindowAggregationNode(this.getPlanNodeId(), this.getAggregationDescriptorList(), this.getGroupByTimeParameter(), this.getScanOrder());
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.aggregationDescriptorList.stream().map(AggregationDescriptor::getOutputColumnNames).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitSlidingWindowAggregation(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.SLIDING_WINDOW_AGGREGATION.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.aggregationDescriptorList.size(), (ByteBuffer)byteBuffer);
        for (AggregationDescriptor aggregationDescriptor : this.aggregationDescriptorList) {
            aggregationDescriptor.serialize(byteBuffer);
        }
        if (this.groupByTimeParameter == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            this.groupByTimeParameter.serialize(byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.SLIDING_WINDOW_AGGREGATION.serialize(stream);
        ReadWriteIOUtils.write((int)this.aggregationDescriptorList.size(), (OutputStream)stream);
        for (AggregationDescriptor aggregationDescriptor : this.aggregationDescriptorList) {
            aggregationDescriptor.serialize(stream);
        }
        if (this.groupByTimeParameter == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            this.groupByTimeParameter.serialize(stream);
        }
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (OutputStream)stream);
    }

    public static SlidingWindowAggregationNode deserialize(ByteBuffer byteBuffer) {
        ArrayList<AggregationDescriptor> aggregationDescriptorList = new ArrayList<AggregationDescriptor>();
        for (int descriptorSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); descriptorSize > 0; --descriptorSize) {
            aggregationDescriptorList.add(AggregationDescriptor.deserialize(byteBuffer));
        }
        byte isNull = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        GroupByTimeParameter groupByTimeParameter = null;
        if (isNull == 1) {
            groupByTimeParameter = GroupByTimeParameter.deserialize(byteBuffer);
        }
        Ordering scanOrder = Ordering.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new SlidingWindowAggregationNode(planNodeId, aggregationDescriptorList, groupByTimeParameter, scanOrder);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SlidingWindowAggregationNode that = (SlidingWindowAggregationNode)o;
        return Objects.equals(this.aggregationDescriptorList, that.aggregationDescriptorList) && Objects.equals(this.groupByTimeParameter, that.groupByTimeParameter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.aggregationDescriptorList, this.groupByTimeParameter);
    }

    public String toString() {
        return String.format("SlidingWindowAggregationNode-%s", this.getPlanNodeId());
    }
}

