/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeUtil;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SourceNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SchemaFetchScanNode
extends SourceNode {
    private final PartialPath storageGroup;
    private final PathPatternTree patternTree;
    private final Map<Integer, Template> templateMap;
    private final boolean withTags;
    private TRegionReplicaSet schemaRegionReplicaSet;

    public SchemaFetchScanNode(PlanNodeId id, PartialPath storageGroup, PathPatternTree patternTree, Map<Integer, Template> templateMap, boolean withTags) {
        super(id);
        this.storageGroup = storageGroup;
        this.patternTree = patternTree;
        this.patternTree.constructTree();
        this.templateMap = templateMap;
        this.withTags = withTags;
    }

    public PartialPath getStorageGroup() {
        return this.storageGroup;
    }

    public PathPatternTree getPatternTree() {
        return this.patternTree;
    }

    public Map<Integer, Template> getTemplateMap() {
        return this.templateMap;
    }

    @Override
    public List<PlanNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNode clone() {
        return new SchemaFetchScanNode(this.getPlanNodeId(), this.storageGroup, this.patternTree, this.templateMap, this.withTags);
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return ImmutableList.of();
    }

    public String toString() {
        return String.format("SchemaFetchScanNode-%s:[StorageGroup: %s, DataRegion: %s]", this.getPlanNodeId(), this.storageGroup, PlanNodeUtil.printRegionReplicaSet(this.getRegionReplicaSet()));
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.SCHEMA_FETCH_SCAN.serialize(byteBuffer);
        this.storageGroup.serialize(byteBuffer);
        this.patternTree.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.templateMap.size(), (ByteBuffer)byteBuffer);
        for (Template template : this.templateMap.values()) {
            template.serialize(byteBuffer);
        }
        ReadWriteIOUtils.write((Boolean)this.withTags, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.SCHEMA_FETCH_SCAN.serialize(stream);
        this.storageGroup.serialize((OutputStream)stream);
        this.patternTree.serialize(stream);
        ReadWriteIOUtils.write((int)this.templateMap.size(), (OutputStream)stream);
        for (Template template : this.templateMap.values()) {
            template.serialize(stream);
        }
        ReadWriteIOUtils.write((Boolean)this.withTags, (OutputStream)stream);
    }

    public static SchemaFetchScanNode deserialize(ByteBuffer byteBuffer) {
        PartialPath storageGroup = (PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)byteBuffer);
        int templateNum = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        HashMap<Integer, Template> templateMap = new HashMap<Integer, Template>();
        for (int i = 0; i < templateNum; ++i) {
            Template template = new Template();
            template.deserialize(byteBuffer);
            templateMap.put(template.getId(), template);
        }
        boolean withTags = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new SchemaFetchScanNode(planNodeId, storageGroup, patternTree, templateMap, withTags);
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.schemaRegionReplicaSet;
    }

    @Override
    public void setRegionReplicaSet(TRegionReplicaSet schemaRegionReplicaSet) {
        this.schemaRegionReplicaSet = schemaRegionReplicaSet;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitSchemaFetchScan(this, context);
    }

    public boolean isWithTags() {
        return this.withTags;
    }
}

