/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.unary;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ExpressionType;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.LeafOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.db.mpp.plan.expression.visitor.ExpressionVisitor;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.jetbrains.annotations.NotNull;

public class InExpression
extends UnaryExpression {
    private final boolean isNotIn;
    private final LinkedHashSet<String> values;

    public InExpression(Expression expression, boolean isNotIn, LinkedHashSet<String> values) {
        super(expression);
        this.isNotIn = isNotIn;
        this.values = values;
    }

    public InExpression(ByteBuffer byteBuffer) {
        super(Expression.deserialize(byteBuffer));
        this.isNotIn = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        this.values = new LinkedHashSet();
        for (int i = 0; i < size; ++i) {
            this.values.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
    }

    public boolean isNotIn() {
        return this.isNotIn;
    }

    public LinkedHashSet<String> getValues() {
        return this.values;
    }

    @Override
    protected String getExpressionStringInternal() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.expression instanceof FunctionExpression || this.expression instanceof LeafOperand) {
            stringBuilder.append(this.expression.getExpressionString()).append(" IN (");
        } else {
            stringBuilder.append('(').append(this.expression.getExpressionString()).append(')').append(" IN (");
        }
        return this.appendValuesToBuild(stringBuilder).toString();
    }

    @NotNull
    private StringBuilder appendValuesToBuild(StringBuilder stringBuilder) {
        Iterator iterator = this.values.iterator();
        if (iterator.hasNext()) {
            stringBuilder.append((String)iterator.next());
        }
        while (iterator.hasNext()) {
            stringBuilder.append(',').append((String)iterator.next());
        }
        stringBuilder.append(')');
        return stringBuilder;
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.IN;
    }

    @Override
    protected Expression constructExpression(Expression childExpression) {
        return new InExpression(childExpression, this.isNotIn, this.values);
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        super.serialize(byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isNotIn, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.values.size(), (ByteBuffer)byteBuffer);
        for (String value : this.values) {
            ReadWriteIOUtils.write((String)value, (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write((Boolean)this.isNotIn, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.values.size(), (OutputStream)stream);
        for (String value : this.values) {
            ReadWriteIOUtils.write((String)value, (OutputStream)stream);
        }
    }

    @Override
    public String getOutputSymbolInternal() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.expression instanceof FunctionExpression || this.expression instanceof ConstantOperand || this.expression instanceof TimeSeriesOperand) {
            stringBuilder.append(this.expression.getOutputSymbol()).append(" IN (");
        } else {
            stringBuilder.append('(').append(this.expression.getOutputSymbol()).append(')').append(" IN (");
        }
        return this.appendValuesToBuild(stringBuilder).toString();
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitInExpression(this, context);
    }
}

