/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.execution.memory;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.db.mpp.execution.exchange.source.ISourceHandle;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.TsBlockSerde;

public class MemorySourceHandle
implements ISourceHandle {
    private final TsBlock result;
    private boolean hasNext;
    private static final TsBlockSerde serde = new TsBlockSerde();

    public MemorySourceHandle(TsBlock result) {
        Validate.notNull((Object)result, (String)"the TsBlock should not be null when constructing MemorySourceHandle", (Object[])new Object[0]);
        this.result = result;
        this.hasNext = true;
    }

    @Override
    public TFragmentInstanceId getLocalFragmentInstanceId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getLocalPlanNodeId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getBufferRetainedSizeInBytes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized TsBlock receive() {
        this.hasNext = false;
        return this.result;
    }

    @Override
    public synchronized ByteBuffer getSerializedTsBlock() throws IoTDBException {
        this.hasNext = false;
        if (this.result.isEmpty()) {
            return null;
        }
        try {
            return serde.serialize(this.result);
        }
        catch (IOException e) {
            throw new IoTDBException((Throwable)e, TSStatusCode.TSBLOCK_SERIALIZE_ERROR.getStatusCode());
        }
    }

    @Override
    public synchronized boolean isFinished() {
        return !this.hasNext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return Futures.immediateFuture(null);
    }

    @Override
    public boolean isAborted() {
        return false;
    }

    @Override
    public void abort() {
    }

    @Override
    public void abort(Throwable t) {
        this.abort();
    }

    @Override
    public void close() {
    }

    @Override
    public void setMaxBytesCanReserve(long maxBytesCanReserve) {
    }
}

