/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientPoolFactory;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.async.AsyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.common.DataNodeEndPoints;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.common.SessionInfo;
import org.apache.iotdb.db.mpp.execution.QueryIdGenerator;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.execution.ExecutionResult;
import org.apache.iotdb.db.mpp.plan.execution.IQueryExecution;
import org.apache.iotdb.db.mpp.plan.execution.QueryExecution;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigExecution;
import org.apache.iotdb.db.mpp.plan.statement.IConfigStatement;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.utils.SetThreadName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Coordinator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Coordinator.class);
    private static final int COORDINATOR_SCHEDULED_EXECUTOR_SIZE = 10;
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final Logger SLOW_SQL_LOGGER = LoggerFactory.getLogger((String)"SLOW_SQL");
    private static final IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> SYNC_INTERNAL_SERVICE_CLIENT_MANAGER = new IClientManager.Factory().createClientManager((IClientPoolFactory)new ClientPoolFactory.SyncDataNodeInternalServiceClientPoolFactory());
    private static final IClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> ASYNC_INTERNAL_SERVICE_CLIENT_MANAGER = new IClientManager.Factory().createClientManager((IClientPoolFactory)new ClientPoolFactory.AsyncDataNodeInternalServiceClientPoolFactory());
    private final ExecutorService executor;
    private final ExecutorService writeOperationExecutor;
    private final ScheduledExecutorService scheduledExecutor;
    private final QueryIdGenerator queryIdGenerator = new QueryIdGenerator();
    private static final Coordinator INSTANCE = new Coordinator();
    private final ConcurrentHashMap<Long, IQueryExecution> queryExecutionMap = new ConcurrentHashMap();

    private Coordinator() {
        this.executor = this.getQueryExecutor();
        this.writeOperationExecutor = this.getWriteExecutor();
        this.scheduledExecutor = this.getScheduledExecutor();
    }

    private IQueryExecution createQueryExecution(Statement statement, MPPQueryContext queryContext, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher, long timeOut, long startTime) {
        queryContext.setTimeOut(timeOut);
        queryContext.setStartTime(startTime);
        if (statement instanceof IConfigStatement) {
            queryContext.setQueryType(((IConfigStatement)((Object)statement)).getQueryType());
            return new ConfigExecution(queryContext, statement, this.executor);
        }
        return new QueryExecution(statement, queryContext, this.executor, this.writeOperationExecutor, this.scheduledExecutor, partitionFetcher, schemaFetcher, SYNC_INTERNAL_SERVICE_CLIENT_MANAGER, ASYNC_INTERNAL_SERVICE_CLIENT_MANAGER);
    }

    public ExecutionResult execute(Statement statement, long queryId, SessionInfo session, String sql, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher, long timeOut) {
        long startTime = System.currentTimeMillis();
        QueryId globalQueryId = this.queryIdGenerator.createNextQueryId();
        try (SetThreadName queryName = new SetThreadName(globalQueryId.getId());){
            MPPQueryContext queryContext;
            IQueryExecution execution;
            if (sql != null && sql.length() > 0) {
                LOGGER.debug("[QueryStart] sql: {}", (Object)sql);
            }
            if ((execution = this.createQueryExecution(statement, queryContext = new MPPQueryContext(sql, globalQueryId, session, DataNodeEndPoints.LOCAL_HOST_DATA_BLOCK_ENDPOINT, DataNodeEndPoints.LOCAL_HOST_INTERNAL_ENDPOINT), partitionFetcher, schemaFetcher, timeOut > 0L ? timeOut : CONFIG.getQueryTimeoutThreshold(), startTime)).isQuery()) {
                this.queryExecutionMap.put(queryId, execution);
            } else {
                queryContext.setTimeOut(Long.MAX_VALUE);
            }
            execution.start();
            ExecutionResult executionResult = execution.getStatus();
            return executionResult;
        }
    }

    public ExecutionResult execute(Statement statement, long queryId, SessionInfo session, String sql, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        return this.execute(statement, queryId, session, sql, partitionFetcher, schemaFetcher, Long.MAX_VALUE);
    }

    public IQueryExecution getQueryExecution(Long queryId) {
        return this.queryExecutionMap.get(queryId);
    }

    public List<IQueryExecution> getAllQueryExecutions() {
        return new ArrayList<IQueryExecution>(this.queryExecutionMap.values());
    }

    public int getQueryExecutionMapSize() {
        return this.queryExecutionMap.size();
    }

    private ExecutorService getQueryExecutor() {
        int coordinatorReadExecutorSize = CONFIG.isClusterMode() ? CONFIG.getCoordinatorReadExecutorSize() : 1;
        return IoTDBThreadPoolFactory.newFixedThreadPool((int)coordinatorReadExecutorSize, (String)ThreadName.MPP_COORDINATOR_EXECUTOR_POOL.getName());
    }

    private ExecutorService getWriteExecutor() {
        int coordinatorWriteExecutorSize = CONFIG.getCoordinatorWriteExecutorSize();
        return IoTDBThreadPoolFactory.newFixedThreadPool((int)coordinatorWriteExecutorSize, (String)ThreadName.MPP_COORDINATOR_WRITE_EXECUTOR.getName());
    }

    private ScheduledExecutorService getScheduledExecutor() {
        return IoTDBThreadPoolFactory.newScheduledThreadPool((int)10, (String)ThreadName.MPP_COORDINATOR_SCHEDULED_EXECUTOR.getName());
    }

    public QueryId createQueryId() {
        return this.queryIdGenerator.createNextQueryId();
    }

    public void cleanupQueryExecution(Long queryId, Throwable t) {
        IQueryExecution queryExecution = this.getQueryExecution(queryId);
        if (queryExecution != null) {
            try (SetThreadName threadName = new SetThreadName(queryExecution.getQueryId());){
                long costTime;
                LOGGER.debug("[CleanUpQuery]]");
                queryExecution.stopAndCleanup(t);
                this.queryExecutionMap.remove(queryId);
                if (queryExecution.isQuery() && (costTime = queryExecution.getTotalExecutionTime()) / 1000000L >= CONFIG.getSlowQueryThreshold()) {
                    SLOW_SQL_LOGGER.info("Cost: {} ms, sql is {}", (Object)(costTime / 1000000L), (Object)queryExecution.getExecuteSQL().orElse("UNKNOWN"));
                }
            }
        }
    }

    public void cleanupQueryExecution(Long queryId) {
        this.cleanupQueryExecution(queryId, null);
    }

    public IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> getInternalServiceClientManager() {
        return SYNC_INTERNAL_SERVICE_CLIENT_MANAGER;
    }

    public static Coordinator getInstance() {
        return INSTANCE;
    }

    public void recordExecutionTime(long queryId, long executionTime) {
        IQueryExecution queryExecution = this.getQueryExecution(queryId);
        if (queryExecution != null) {
            queryExecution.recordExecutionTime(executionTime);
        }
    }

    public long getTotalExecutionTime(long queryId) {
        IQueryExecution queryExecution = this.getQueryExecution(queryId);
        if (queryExecution != null) {
            return queryExecution.getTotalExecutionTime();
        }
        return -1L;
    }
}

