/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.schedule.queue;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.mpp.execution.schedule.queue.ID;
import org.apache.iotdb.db.mpp.execution.schedule.queue.IDIndexedAccessible;

public abstract class IndexedBlockingQueue<E extends IDIndexedAccessible> {
    protected final int MAX_CAPACITY;
    protected final E queryHolder;
    protected int size;

    public IndexedBlockingQueue(int maxCapacity, E queryHolder) {
        this.MAX_CAPACITY = maxCapacity;
        this.queryHolder = queryHolder;
    }

    public synchronized E poll() throws InterruptedException {
        while (this.isEmpty()) {
            this.wait();
        }
        E output = this.pollFirst();
        --this.size;
        return output;
    }

    public synchronized void push(E element) {
        if (element == null) {
            throw new NullPointerException("pushed element is null");
        }
        Preconditions.checkState((this.size < this.MAX_CAPACITY ? 1 : 0) != 0, (Object)"The system can't allow more queries.");
        this.pushToQueue(element);
        ++this.size;
        this.notifyAll();
    }

    public synchronized E remove(ID id) {
        this.queryHolder.setId(id);
        E output = this.remove(this.queryHolder);
        if (output == null) {
            return null;
        }
        --this.size;
        Preconditions.checkState((this.size >= 0 ? 1 : 0) != 0, (Object)"The size of readyQueue cannot be negative.");
        return output;
    }

    public synchronized E get(ID id) {
        this.queryHolder.setId(id);
        return this.get(this.queryHolder);
    }

    public synchronized void clear() {
        this.clearAllElements();
        this.size = 0;
    }

    public final synchronized int size() {
        return this.size;
    }

    protected abstract boolean isEmpty();

    protected abstract E pollFirst();

    protected abstract void pushToQueue(E var1);

    protected abstract E remove(E var1);

    protected abstract boolean contains(E var1);

    protected abstract E get(E var1);

    protected abstract void clearAllElements();
}

