/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.commons.schema.node.MNodeType;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilderStatus;
import org.apache.iotdb.tsfile.utils.Binary;

public class NodeManageMemoryMergeOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private final Set<TSchemaNode> data;
    private final Set<String> nameSet;
    private final Operator child;
    private boolean isReadingMemory;
    private final List<TSDataType> outputDataTypes;

    public NodeManageMemoryMergeOperator(OperatorContext operatorContext, Set<TSchemaNode> data, Operator child) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.data = data;
        this.nameSet = data.stream().map(schemaNode -> schemaNode.getNodeName()).collect(Collectors.toSet());
        this.child = Objects.requireNonNull(child, "child operator is null");
        this.isReadingMemory = true;
        this.outputDataTypes = ColumnHeaderConstant.showChildPathsColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.isReadingMemory ? NOT_BLOCKED : this.child.isBlocked();
    }

    @Override
    public TsBlock next() throws Exception {
        if (this.isReadingMemory) {
            this.isReadingMemory = false;
            return this.transferToTsBlock(this.data);
        }
        TsBlock block = this.child.nextWithTimer();
        if (block == null) {
            return null;
        }
        HashSet<TSchemaNode> nodePaths = new HashSet<TSchemaNode>();
        for (int i = 0; i < block.getPositionCount(); ++i) {
            TSchemaNode schemaNode = new TSchemaNode(block.getColumn(0).getBinary(i).toString(), Byte.parseByte(block.getColumn(1).getBinary(i).toString()));
            if (this.nameSet.contains(schemaNode.getNodeName())) continue;
            nodePaths.add(schemaNode);
            this.nameSet.add(schemaNode.getNodeName());
        }
        return this.transferToTsBlock(nodePaths);
    }

    private TsBlock transferToTsBlock(Set<TSchemaNode> nodePaths) {
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(this.outputDataTypes);
        TreeSet<TSchemaNode> sortSet = new TreeSet<TSchemaNode>((o1, o2) -> {
            if (o1.getNodeType() == o2.getNodeType()) {
                return o1.getNodeName().compareTo(o2.getNodeName());
            }
            return o1.getNodeType() - o2.getNodeType();
        });
        sortSet.addAll(nodePaths);
        sortSet.forEach(node -> {
            tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
            tsBlockBuilder.getColumnBuilder(0).writeBinary(new Binary(node.getNodeName()));
            tsBlockBuilder.getColumnBuilder(1).writeBinary(new Binary(MNodeType.getMNodeType((byte)node.getNodeType()).getNodeTypeName()));
            tsBlockBuilder.declarePosition();
        });
        return tsBlockBuilder.build();
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.isReadingMemory || this.child.hasNextWithTimer();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.isReadingMemory && this.child.isFinished();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return Math.max(2L * (long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, this.child.calculateMaxPeekMemory());
    }

    @Override
    public long calculateMaxReturnSize() {
        return Math.max((long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, this.child.calculateMaxReturnSize());
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return (long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES + this.child.calculateRetainedSizeAfterCallingNext();
    }
}

