/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;

public class OffsetOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private long remainingOffset;
    private final Operator child;

    public OffsetOperator(OperatorContext operatorContext, long offset, Operator child) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset must be at least zero");
        this.remainingOffset = offset;
        this.child = Objects.requireNonNull(child, "child operator is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public TsBlock next() throws Exception {
        TsBlock block = this.child.nextWithTimer();
        if (block == null) {
            return null;
        }
        if (this.remainingOffset > 0L) {
            int offset = (int)Math.min(this.remainingOffset, (long)block.getPositionCount());
            this.remainingOffset -= (long)offset;
            return block.getRegion(offset, block.getPositionCount() - offset);
        }
        return block;
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.child.hasNextWithTimer();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.child.isFinished();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.child.calculateMaxPeekMemory();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.child.calculateMaxReturnSize();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateRetainedSizeAfterCallingNext();
    }
}

