/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.executor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.service.metric.PerformanceOverviewMetrics;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.response.ConsensusWriteResponse;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.consensus.SchemaRegionConsensusImpl;
import org.apache.iotdb.db.exception.metadata.MeasurementAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.SchemaQuotaExceededException;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngine;
import org.apache.iotdb.db.metadata.template.ClusterTemplateManager;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.mpp.execution.executor.RegionExecutionResult;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.ActivateTemplateNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.AlterTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.BatchActivateTemplateNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.CreateAlignedTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.CreateMultiTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.CreateTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.InternalBatchActivateTemplateNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.InternalCreateMultiTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.InternalCreateTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.MeasurementGroup;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.view.CreateLogicalViewNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertMultiTabletsNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowsOfOneDeviceNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.service.thrift.impl.DataNodeRegionManager;
import org.apache.iotdb.db.trigger.executor.TriggerFireResult;
import org.apache.iotdb.db.trigger.executor.TriggerFireVisitor;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.trigger.api.enums.TriggerEvent;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionWriteExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegionWriteExecutor.class);
    private static final DataNodeRegionManager REGION_MANAGER = DataNodeRegionManager.getInstance();
    private static final PerformanceOverviewMetrics PERFORMANCE_OVERVIEW_METRICS = PerformanceOverviewMetrics.getInstance();

    public RegionExecutionResult execute(ConsensusGroupId groupId, PlanNode planNode) {
        try {
            WritePlanNodeExecutionContext context = new WritePlanNodeExecutionContext(groupId, REGION_MANAGER.getRegionLock(groupId));
            WritePlanNodeExecutionVisitor executionVisitor = new WritePlanNodeExecutionVisitor();
            return planNode.accept(executionVisitor, context);
        }
        catch (Throwable e) {
            LOGGER.error(e.getMessage(), e);
            RegionExecutionResult result = new RegionExecutionResult();
            result.setAccepted(false);
            result.setMessage(e.getMessage());
            result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage()));
            return result;
        }
    }

    public static ConsensusWriteResponse fireTriggerAndInsert(ConsensusGroupId groupId, PlanNode planNode) {
        ConsensusWriteResponse writeResponse;
        long triggerCostTime = 0L;
        TriggerFireVisitor visitor = new TriggerFireVisitor();
        long startTime = System.nanoTime();
        TriggerFireResult result = visitor.process(planNode, TriggerEvent.BEFORE_INSERT);
        triggerCostTime += System.nanoTime() - startTime;
        if (result.equals((Object)TriggerFireResult.TERMINATION)) {
            TSStatus triggerError = new TSStatus(TSStatusCode.TRIGGER_FIRE_ERROR.getStatusCode());
            triggerError.setMessage("Failed to complete the insertion because trigger error before the insertion.");
            writeResponse = ConsensusWriteResponse.newBuilder().setStatus(triggerError).build();
        } else {
            boolean hasFailedTriggerBeforeInsertion = result.equals((Object)TriggerFireResult.FAILED_NO_TERMINATION);
            long startWriteTime = System.nanoTime();
            writeResponse = DataRegionConsensusImpl.getInstance().write(groupId, (IConsensusRequest)planNode);
            PERFORMANCE_OVERVIEW_METRICS.recordScheduleStorageCost(System.nanoTime() - startWriteTime);
            if (writeResponse.isSuccessful()) {
                startTime = System.nanoTime();
                result = visitor.process(planNode, TriggerEvent.AFTER_INSERT);
                if (hasFailedTriggerBeforeInsertion || !result.equals((Object)TriggerFireResult.SUCCESS)) {
                    TSStatus triggerError = new TSStatus(TSStatusCode.TRIGGER_FIRE_ERROR.getStatusCode());
                    triggerError.setMessage("Meet trigger error before/after the insertion, the insertion itself is completed.");
                    writeResponse = ConsensusWriteResponse.newBuilder().setStatus(triggerError).build();
                }
                triggerCostTime += System.nanoTime() - startTime;
            }
        }
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleTriggerCost(triggerCostTime);
        return writeResponse;
    }

    private static class WritePlanNodeExecutionContext {
        private final ConsensusGroupId regionId;
        private final ReentrantReadWriteLock regionRWLock;

        WritePlanNodeExecutionContext(ConsensusGroupId regionId, ReentrantReadWriteLock regionRWLock) {
            this.regionId = regionId;
            this.regionRWLock = regionRWLock;
        }

        public ConsensusGroupId getRegionId() {
            return this.regionId;
        }

        public ReentrantReadWriteLock getRegionWriteValidationRWLock() {
            return this.regionRWLock;
        }
    }

    private static class WritePlanNodeExecutionVisitor
    extends PlanVisitor<RegionExecutionResult, WritePlanNodeExecutionContext> {
        private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

        private WritePlanNodeExecutionVisitor() {
        }

        @Override
        public RegionExecutionResult visitPlan(PlanNode node, WritePlanNodeExecutionContext context) {
            RegionExecutionResult response = new RegionExecutionResult();
            if (CommonDescriptor.getInstance().getConfig().isReadOnly()) {
                response.setAccepted(false);
                response.setMessage("Fail to do non-query operations because system is read-only.");
                response.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SYSTEM_READ_ONLY, (String)"Fail to do non-query operations because system is read-only."));
                return response;
            }
            ConsensusWriteResponse writeResponse = this.executePlanNodeInConsensusLayer(context.getRegionId(), node);
            if (writeResponse.getStatus() != null) {
                response.setAccepted(TSStatusCode.SUCCESS_STATUS.getStatusCode() == writeResponse.getStatus().getCode());
                response.setMessage(writeResponse.getStatus().message);
                response.setStatus(writeResponse.getStatus());
            } else {
                LOGGER.error("Something wrong happened while calling consensus layer's write API.", (Throwable)writeResponse.getException());
                response.setAccepted(false);
                response.setMessage(writeResponse.getException().toString());
                response.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)writeResponse.getErrorMessage()));
            }
            return response;
        }

        private ConsensusWriteResponse executePlanNodeInConsensusLayer(ConsensusGroupId groupId, PlanNode planNode) {
            if (groupId instanceof DataRegionId) {
                return DataRegionConsensusImpl.getInstance().write(groupId, (IConsensusRequest)planNode);
            }
            return SchemaRegionConsensusImpl.getInstance().write(groupId, (IConsensusRequest)planNode);
        }

        @Override
        public RegionExecutionResult visitInsertRow(InsertRowNode node, WritePlanNodeExecutionContext context) {
            return this.executeDataInsert(node, context);
        }

        @Override
        public RegionExecutionResult visitInsertTablet(InsertTabletNode node, WritePlanNodeExecutionContext context) {
            return this.executeDataInsert(node, context);
        }

        @Override
        public RegionExecutionResult visitInsertRows(InsertRowsNode node, WritePlanNodeExecutionContext context) {
            return this.executeDataInsert(node, context);
        }

        @Override
        public RegionExecutionResult visitInsertMultiTablets(InsertMultiTabletsNode node, WritePlanNodeExecutionContext context) {
            return this.executeDataInsert(node, context);
        }

        @Override
        public RegionExecutionResult visitInsertRowsOfOneDevice(InsertRowsOfOneDeviceNode node, WritePlanNodeExecutionContext context) {
            return this.executeDataInsert(node, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RegionExecutionResult executeDataInsert(InsertNode insertNode, WritePlanNodeExecutionContext context) {
            RegionExecutionResult response = new RegionExecutionResult();
            context.getRegionWriteValidationRWLock().readLock().lock();
            try {
                ConsensusWriteResponse writeResponse = RegionWriteExecutor.fireTriggerAndInsert(context.getRegionId(), insertNode);
                if (writeResponse.getStatus() != null) {
                    response.setAccepted(TSStatusCode.SUCCESS_STATUS.getStatusCode() == writeResponse.getStatus().getCode());
                    if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != writeResponse.getStatus().getCode()) {
                        response.setMessage(writeResponse.getStatus().message);
                        response.setStatus(writeResponse.getStatus());
                    } else {
                        response.setMessage(writeResponse.getStatus().message);
                    }
                } else {
                    LOGGER.warn("Something wrong happened while calling consensus layer's write API.", (Throwable)writeResponse.getException());
                    response.setAccepted(false);
                    response.setMessage(writeResponse.getException().toString());
                    response.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRITE_PROCESS_ERROR, (String)writeResponse.getException().toString()));
                }
                RegionExecutionResult regionExecutionResult = response;
                return regionExecutionResult;
            }
            finally {
                context.getRegionWriteValidationRWLock().readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RegionExecutionResult visitDeleteData(DeleteDataNode node, WritePlanNodeExecutionContext context) {
            context.getRegionWriteValidationRWLock().writeLock().lock();
            try {
                RegionExecutionResult regionExecutionResult = (RegionExecutionResult)super.visitDeleteData(node, context);
                return regionExecutionResult;
            }
            finally {
                context.getRegionWriteValidationRWLock().writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RegionExecutionResult visitCreateTimeSeries(CreateTimeSeriesNode node, WritePlanNodeExecutionContext context) {
            ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion((SchemaRegionId)context.getRegionId());
            RegionExecutionResult result = this.checkQuotaBeforeCreatingTimeSeries(schemaRegion, node.getPath().getDevicePath(), 1);
            if (result != null) {
                return result;
            }
            if (this.config.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
                context.getRegionWriteValidationRWLock().writeLock().lock();
                try {
                    Map<Integer, MetadataException> failingMeasurementMap = schemaRegion.checkMeasurementExistence(node.getPath().getDevicePath(), Collections.singletonList(node.getPath().getMeasurement()), Collections.singletonList(node.getAlias()));
                    if (failingMeasurementMap.isEmpty()) {
                        RegionExecutionResult regionExecutionResult = (RegionExecutionResult)super.visitCreateTimeSeries(node, context);
                        return regionExecutionResult;
                    }
                    MetadataException metadataException = failingMeasurementMap.get(0);
                    LOGGER.error("Metadata error: ", (Throwable)metadataException);
                    result = new RegionExecutionResult();
                    result.setAccepted(false);
                    result.setMessage(metadataException.getMessage());
                    result.setStatus(RpcUtils.getStatus((int)metadataException.getErrorCode(), (String)metadataException.getMessage()));
                    RegionExecutionResult regionExecutionResult = result;
                    return regionExecutionResult;
                }
                finally {
                    context.getRegionWriteValidationRWLock().writeLock().unlock();
                }
            }
            return (RegionExecutionResult)super.visitCreateTimeSeries(node, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RegionExecutionResult visitCreateAlignedTimeSeries(CreateAlignedTimeSeriesNode node, WritePlanNodeExecutionContext context) {
            ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion((SchemaRegionId)context.getRegionId());
            RegionExecutionResult result = this.checkQuotaBeforeCreatingTimeSeries(schemaRegion, node.getDevicePath(), node.getMeasurements().size());
            if (result != null) {
                return result;
            }
            if (this.config.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
                context.getRegionWriteValidationRWLock().writeLock().lock();
                try {
                    Map<Integer, MetadataException> failingMeasurementMap = schemaRegion.checkMeasurementExistence(node.getDevicePath(), node.getMeasurements(), node.getAliasList());
                    if (failingMeasurementMap.isEmpty()) {
                        RegionExecutionResult regionExecutionResult = (RegionExecutionResult)super.visitCreateAlignedTimeSeries(node, context);
                        return regionExecutionResult;
                    }
                    MetadataException metadataException = failingMeasurementMap.values().iterator().next();
                    LOGGER.error("Metadata error: ", (Throwable)metadataException);
                    result = new RegionExecutionResult();
                    result.setAccepted(false);
                    result.setMessage(metadataException.getMessage());
                    result.setStatus(RpcUtils.getStatus((int)metadataException.getErrorCode(), (String)metadataException.getMessage()));
                    RegionExecutionResult regionExecutionResult = result;
                    return regionExecutionResult;
                }
                finally {
                    context.getRegionWriteValidationRWLock().writeLock().unlock();
                }
            }
            return (RegionExecutionResult)super.visitCreateAlignedTimeSeries(node, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RegionExecutionResult visitCreateMultiTimeSeries(CreateMultiTimeSeriesNode node, WritePlanNodeExecutionContext context) {
            ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion((SchemaRegionId)context.getRegionId());
            for (Map.Entry<PartialPath, MeasurementGroup> entry : node.getMeasurementGroupMap().entrySet()) {
                RegionExecutionResult result = this.checkQuotaBeforeCreatingTimeSeries(schemaRegion, entry.getKey(), entry.getValue().getMeasurements().size());
                if (result == null) continue;
                return result;
            }
            if (this.config.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
                context.getRegionWriteValidationRWLock().writeLock().lock();
                try {
                    ArrayList<TSStatus> failingStatus = new ArrayList<TSStatus>();
                    Map<PartialPath, MeasurementGroup> measurementGroupMap = node.getMeasurementGroupMap();
                    ArrayList<PartialPath> emptyDeviceList = new ArrayList<PartialPath>();
                    for (Map.Entry<PartialPath, MeasurementGroup> entry : measurementGroupMap.entrySet()) {
                        Map<Integer, MetadataException> failingMeasurementMap = schemaRegion.checkMeasurementExistence(entry.getKey(), entry.getValue().getMeasurements(), entry.getValue().getAliasList());
                        if (failingMeasurementMap.isEmpty()) continue;
                        for (Map.Entry<Integer, MetadataException> failingMeasurement : failingMeasurementMap.entrySet()) {
                            LOGGER.error("Metadata error: ", (Throwable)failingMeasurement.getValue());
                            failingStatus.add(RpcUtils.getStatus((int)failingMeasurement.getValue().getErrorCode(), (String)failingMeasurement.getValue().getMessage()));
                        }
                        entry.getValue().removeMeasurements(failingMeasurementMap.keySet());
                        if (!entry.getValue().isEmpty()) continue;
                        emptyDeviceList.add(entry.getKey());
                    }
                    for (Object emptyDevice : emptyDeviceList) {
                        measurementGroupMap.remove(emptyDevice);
                    }
                    if (!measurementGroupMap.isEmpty()) {
                        RegionExecutionResult executionResult = (RegionExecutionResult)super.visitCreateMultiTimeSeries(node, context);
                        if (failingStatus.isEmpty()) {
                            Object emptyDevice;
                            emptyDevice = executionResult;
                            return emptyDevice;
                        }
                        TSStatus executionStatus = executionResult.getStatus();
                        if (executionStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                            failingStatus.addAll(executionStatus.getSubStatus());
                        } else if (executionStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            failingStatus.add(executionStatus);
                        }
                    }
                    TSStatus status = RpcUtils.getStatus(failingStatus);
                    RegionExecutionResult failingResult = new RegionExecutionResult();
                    failingResult.setAccepted(false);
                    failingResult.setMessage(status.getMessage());
                    failingResult.setStatus(status);
                    RegionExecutionResult regionExecutionResult = failingResult;
                    return regionExecutionResult;
                }
                finally {
                    context.getRegionWriteValidationRWLock().writeLock().unlock();
                }
            }
            return (RegionExecutionResult)super.visitCreateMultiTimeSeries(node, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RegionExecutionResult visitInternalCreateTimeSeries(InternalCreateTimeSeriesNode node, WritePlanNodeExecutionContext context) {
            ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion((SchemaRegionId)context.getRegionId());
            RegionExecutionResult result = this.checkQuotaBeforeCreatingTimeSeries(schemaRegion, node.getDevicePath(), node.getMeasurementGroup().size());
            if (result != null) {
                return result;
            }
            if (this.config.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
                context.getRegionWriteValidationRWLock().writeLock().lock();
                try {
                    ArrayList<TSStatus> failingStatus = new ArrayList<TSStatus>();
                    ArrayList<TSStatus> alreadyExistingStatus = new ArrayList<TSStatus>();
                    MeasurementGroup measurementGroup = node.getMeasurementGroup();
                    Map<Integer, MetadataException> failingMeasurementMap = schemaRegion.checkMeasurementExistence(node.getDevicePath(), measurementGroup.getMeasurements(), measurementGroup.getAliasList());
                    for (Map.Entry<Integer, MetadataException> failingMeasurement : failingMeasurementMap.entrySet()) {
                        MetadataException metadataException = failingMeasurement.getValue();
                        if (metadataException.getErrorCode() == TSStatusCode.TIMESERIES_ALREADY_EXIST.getStatusCode()) {
                            alreadyExistingStatus.add(RpcUtils.getStatus((int)metadataException.getErrorCode(), (String)MeasurementPath.transformDataToString((MeasurementPath)((MeasurementAlreadyExistException)metadataException).getMeasurementPath())));
                            continue;
                        }
                        LOGGER.warn("Metadata error: ", (Throwable)metadataException);
                        failingStatus.add(RpcUtils.getStatus((int)metadataException.getErrorCode(), (String)metadataException.getMessage()));
                    }
                    measurementGroup.removeMeasurements(failingMeasurementMap.keySet());
                    RegionExecutionResult regionExecutionResult = this.processExecutionResultOfInternalCreateSchema((RegionExecutionResult)super.visitInternalCreateTimeSeries(node, context), failingStatus, alreadyExistingStatus);
                    return regionExecutionResult;
                }
                finally {
                    context.getRegionWriteValidationRWLock().writeLock().unlock();
                }
            }
            return (RegionExecutionResult)super.visitInternalCreateTimeSeries(node, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RegionExecutionResult visitInternalCreateMultiTimeSeries(InternalCreateMultiTimeSeriesNode node, WritePlanNodeExecutionContext context) {
            ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion((SchemaRegionId)context.getRegionId());
            for (Map.Entry<PartialPath, Pair<Boolean, MeasurementGroup>> deviceEntry : node.getDeviceMap().entrySet()) {
                RegionExecutionResult result = this.checkQuotaBeforeCreatingTimeSeries(schemaRegion, deviceEntry.getKey(), ((MeasurementGroup)deviceEntry.getValue().getRight()).size());
                if (result == null) continue;
                return result;
            }
            if (this.config.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
                context.getRegionWriteValidationRWLock().writeLock().lock();
                try {
                    ArrayList<TSStatus> failingStatus = new ArrayList<TSStatus>();
                    ArrayList<TSStatus> alreadyExistingStatus = new ArrayList<TSStatus>();
                    for (Map.Entry<PartialPath, Pair<Boolean, MeasurementGroup>> deviceEntry : node.getDeviceMap().entrySet()) {
                        MeasurementGroup measurementGroup = (MeasurementGroup)deviceEntry.getValue().right;
                        Map<Integer, MetadataException> failingMeasurementMap = schemaRegion.checkMeasurementExistence(deviceEntry.getKey(), measurementGroup.getMeasurements(), measurementGroup.getAliasList());
                        for (Map.Entry<Integer, MetadataException> failingMeasurement : failingMeasurementMap.entrySet()) {
                            MetadataException metadataException = failingMeasurement.getValue();
                            if (metadataException.getErrorCode() == TSStatusCode.TIMESERIES_ALREADY_EXIST.getStatusCode()) {
                                alreadyExistingStatus.add(RpcUtils.getStatus((int)metadataException.getErrorCode(), (String)MeasurementPath.transformDataToString((MeasurementPath)((MeasurementAlreadyExistException)metadataException).getMeasurementPath())));
                                continue;
                            }
                            LOGGER.warn("Metadata error: ", (Throwable)metadataException);
                            failingStatus.add(RpcUtils.getStatus((int)metadataException.getErrorCode(), (String)metadataException.getMessage()));
                        }
                        measurementGroup.removeMeasurements(failingMeasurementMap.keySet());
                    }
                    RegionExecutionResult regionExecutionResult = this.processExecutionResultOfInternalCreateSchema((RegionExecutionResult)super.visitInternalCreateMultiTimeSeries(node, context), failingStatus, alreadyExistingStatus);
                    return regionExecutionResult;
                }
                finally {
                    context.getRegionWriteValidationRWLock().writeLock().unlock();
                }
            }
            return (RegionExecutionResult)super.visitInternalCreateMultiTimeSeries(node, context);
        }

        private RegionExecutionResult checkQuotaBeforeCreatingTimeSeries(ISchemaRegion schemaRegion, PartialPath path, int size) {
            try {
                schemaRegion.checkSchemaQuota(path, size);
            }
            catch (SchemaQuotaExceededException e) {
                RegionExecutionResult result = new RegionExecutionResult();
                result.setAccepted(false);
                result.setMessage(e.getMessage());
                result.setStatus(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
                return result;
            }
            return null;
        }

        private RegionExecutionResult processExecutionResultOfInternalCreateSchema(RegionExecutionResult executionResult, List<TSStatus> failingStatus, List<TSStatus> alreadyExistingStatus) {
            TSStatus status;
            TSStatus executionStatus = executionResult.getStatus();
            if (failingStatus.isEmpty()) {
                if (executionStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                    if (((TSStatus)executionStatus.getSubStatus().get(0)).getCode() == TSStatusCode.TIMESERIES_ALREADY_EXIST.getStatusCode()) {
                        alreadyExistingStatus.addAll(executionStatus.getSubStatus());
                    } else {
                        failingStatus.addAll(executionStatus.getSubStatus());
                    }
                } else if (executionStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    failingStatus.add(executionStatus);
                }
            } else if (executionStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                if (((TSStatus)executionStatus.getSubStatus().get(0)).getCode() != TSStatusCode.TIMESERIES_ALREADY_EXIST.getStatusCode()) {
                    failingStatus.addAll(executionStatus.getSubStatus());
                }
            } else if (executionStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                failingStatus.add(executionStatus);
            }
            RegionExecutionResult result = new RegionExecutionResult();
            if (failingStatus.isEmpty() && alreadyExistingStatus.isEmpty()) {
                status = RpcUtils.SUCCESS_STATUS;
                result.setAccepted(true);
            } else if (failingStatus.isEmpty()) {
                status = RpcUtils.getStatus(alreadyExistingStatus);
                result.setAccepted(true);
            } else {
                status = RpcUtils.getStatus(failingStatus);
                result.setAccepted(false);
            }
            result.setMessage(status.getMessage());
            result.setStatus(status);
            return result;
        }

        @Override
        public RegionExecutionResult visitAlterTimeSeries(AlterTimeSeriesNode node, WritePlanNodeExecutionContext context) {
            ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion((SchemaRegionId)context.getRegionId());
            try {
                List<MeasurementPath> measurementPathList = schemaRegion.fetchSchema(node.getPath(), Collections.emptyMap(), false);
                if (node.isAlterView()) {
                    if (measurementPathList.isEmpty()) {
                        throw new PathNotExistException(node.getPath().getFullPath());
                    }
                    if (!measurementPathList.get(0).getMeasurementSchema().isLogicalView()) {
                        throw new MetadataException(String.format("%s is not view.", measurementPathList.get(0).getFullPath()));
                    }
                }
                return (RegionExecutionResult)super.visitAlterTimeSeries(node, context);
            }
            catch (MetadataException e) {
                RegionExecutionResult result = new RegionExecutionResult();
                result.setAccepted(true);
                result.setMessage(e.getMessage());
                result.setStatus(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RegionExecutionResult visitActivateTemplate(ActivateTemplateNode node, WritePlanNodeExecutionContext context) {
            context.getRegionWriteValidationRWLock().readLock().lock();
            try {
                Pair<Template, PartialPath> templateSetInfo = ClusterTemplateManager.getInstance().checkTemplateSetInfo(node.getActivatePath());
                if (templateSetInfo == null) {
                    RegionExecutionResult result = new RegionExecutionResult();
                    result.setAccepted(false);
                    String message = String.format("Template is being unsetting from path %s. Please try activating later.", node.getPathSetTemplate());
                    result.setMessage(message);
                    result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)message));
                    RegionExecutionResult regionExecutionResult = result;
                    return regionExecutionResult;
                }
                ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion((SchemaRegionId)context.getRegionId());
                RegionExecutionResult result = this.checkQuotaBeforeCreatingTimeSeries(schemaRegion, node.getActivatePath(), ((Template)templateSetInfo.left).getMeasurementNumber());
                RegionExecutionResult regionExecutionResult = result == null ? (RegionExecutionResult)super.visitActivateTemplate(node, context) : result;
                return regionExecutionResult;
            }
            finally {
                context.getRegionWriteValidationRWLock().readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RegionExecutionResult visitBatchActivateTemplate(BatchActivateTemplateNode node, WritePlanNodeExecutionContext context) {
            context.getRegionWriteValidationRWLock().readLock().lock();
            try {
                ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion((SchemaRegionId)context.getRegionId());
                for (PartialPath devicePath : node.getTemplateActivationMap().keySet()) {
                    RegionExecutionResult result;
                    Pair<Template, PartialPath> templateSetInfo = ClusterTemplateManager.getInstance().checkTemplateSetInfo(devicePath);
                    if (templateSetInfo == null) {
                        result = new RegionExecutionResult();
                        result.setAccepted(false);
                        String message = String.format("Template is being unsetting from path %s. Please try activating later.", node.getPathSetTemplate(devicePath));
                        result.setMessage(message);
                        result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)message));
                        RegionExecutionResult regionExecutionResult = result;
                        return regionExecutionResult;
                    }
                    result = this.checkQuotaBeforeCreatingTimeSeries(schemaRegion, devicePath, ((Template)templateSetInfo.left).getMeasurementNumber());
                    if (result == null) continue;
                    RegionExecutionResult regionExecutionResult = result;
                    return regionExecutionResult;
                }
                RegionExecutionResult regionExecutionResult = (RegionExecutionResult)super.visitBatchActivateTemplate(node, context);
                return regionExecutionResult;
            }
            finally {
                context.getRegionWriteValidationRWLock().readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RegionExecutionResult visitInternalBatchActivateTemplate(InternalBatchActivateTemplateNode node, WritePlanNodeExecutionContext context) {
            context.getRegionWriteValidationRWLock().readLock().lock();
            try {
                ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion((SchemaRegionId)context.getRegionId());
                for (Map.Entry<PartialPath, Pair<Integer, Integer>> entry : node.getTemplateActivationMap().entrySet()) {
                    RegionExecutionResult result;
                    Pair<Template, PartialPath> templateSetInfo = ClusterTemplateManager.getInstance().checkTemplateSetInfo(entry.getKey());
                    if (templateSetInfo == null) {
                        result = new RegionExecutionResult();
                        result.setAccepted(false);
                        String message = String.format("Template is being unsetting from prefix path of %s. Please try activating later.", new PartialPath(Arrays.copyOf(entry.getKey().getNodes(), (Integer)entry.getValue().right + 1)).getFullPath());
                        result.setMessage(message);
                        result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)message));
                        RegionExecutionResult regionExecutionResult = result;
                        return regionExecutionResult;
                    }
                    result = this.checkQuotaBeforeCreatingTimeSeries(schemaRegion, entry.getKey(), ((Template)templateSetInfo.left).getMeasurementNumber());
                    if (result == null) continue;
                    RegionExecutionResult regionExecutionResult = result;
                    return regionExecutionResult;
                }
                RegionExecutionResult regionExecutionResult = (RegionExecutionResult)super.visitInternalBatchActivateTemplate(node, context);
                return regionExecutionResult;
            }
            finally {
                context.getRegionWriteValidationRWLock().readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RegionExecutionResult visitCreateLogicalView(CreateLogicalViewNode node, WritePlanNodeExecutionContext context) {
            ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion((SchemaRegionId)context.getRegionId());
            if (this.config.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
                context.getRegionWriteValidationRWLock().writeLock().lock();
                try {
                    List<PartialPath> targetPaths = node.getViewPathList();
                    ArrayList<MetadataException> failingMetadataException = new ArrayList<MetadataException>();
                    for (PartialPath thisPath : targetPaths) {
                        Map<Integer, MetadataException> failingMeasurementMap = schemaRegion.checkMeasurementExistence(thisPath.getDevicePath(), Collections.singletonList(thisPath.getMeasurement()), null);
                        for (Map.Entry<Integer, MetadataException> entry : failingMeasurementMap.entrySet()) {
                            failingMetadataException.add(entry.getValue());
                        }
                    }
                    if (!failingMetadataException.isEmpty()) {
                        MetadataException metadataException = (MetadataException)((Object)failingMetadataException.get(0));
                        LOGGER.error("Metadata error: ", (Throwable)metadataException);
                        RegionExecutionResult result = new RegionExecutionResult();
                        result.setAccepted(false);
                        result.setMessage(metadataException.getMessage());
                        result.setStatus(RpcUtils.getStatus((int)metadataException.getErrorCode(), (String)metadataException.getMessage()));
                        RegionExecutionResult regionExecutionResult = result;
                        return regionExecutionResult;
                    }
                    RegionExecutionResult regionExecutionResult = (RegionExecutionResult)super.visitCreateLogicalView(node, context);
                    return regionExecutionResult;
                }
                finally {
                    context.getRegionWriteValidationRWLock().writeLock().unlock();
                }
            }
            return (RegionExecutionResult)super.visitCreateLogicalView(node, context);
        }
    }
}

