/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.aggregation;

import org.apache.iotdb.db.mpp.aggregation.Accumulator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.utils.BitMap;

public class TimeDurationAccumulator
implements Accumulator {
    protected long minTime = Long.MAX_VALUE;
    protected long maxTime = Long.MIN_VALUE;
    protected boolean initResult = false;

    @Override
    public void addInput(Column[] column, BitMap bitMap, int lastIndex) {
        for (int i = 0; i <= lastIndex; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.initResult = true;
            this.updateMaxTime(column[0].getLong(i));
            this.updateMinTime(column[0].getLong(i));
        }
    }

    @Override
    public void addIntermediate(Column[] partialResult) {
        if (partialResult[0].isNull(0)) {
            return;
        }
        this.initResult = true;
        this.updateMaxTime(partialResult[0].getLong(0));
        this.updateMinTime(partialResult[1].getLong(0));
    }

    @Override
    public void addStatistics(Statistics statistics) {
        this.updateMaxTime(statistics.getEndTime());
        this.updateMinTime(statistics.getStartTime());
    }

    @Override
    public void setFinal(Column finalResult) {
        if (finalResult.isNull(0)) {
            return;
        }
        this.initResult = true;
        this.maxTime = finalResult.getLong(0);
        this.minTime = 0L;
    }

    @Override
    public void outputIntermediate(ColumnBuilder[] tsBlockBuilder) {
        if (!this.initResult) {
            tsBlockBuilder[0].appendNull();
            tsBlockBuilder[1].appendNull();
        } else {
            tsBlockBuilder[0].writeLong(this.maxTime);
            tsBlockBuilder[1].writeLong(this.minTime);
        }
    }

    @Override
    public void outputFinal(ColumnBuilder tsBlockBuilder) {
        if (!this.initResult) {
            tsBlockBuilder.appendNull();
        } else {
            tsBlockBuilder.writeLong(this.maxTime - this.minTime);
        }
    }

    @Override
    public void reset() {
        this.initResult = false;
        this.maxTime = 0L;
        this.minTime = Long.MAX_VALUE;
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public TSDataType[] getIntermediateType() {
        return new TSDataType[]{TSDataType.INT64, TSDataType.INT64};
    }

    @Override
    public TSDataType getFinalType() {
        return TSDataType.INT64;
    }

    protected void updateMaxTime(long curTime) {
        this.initResult = true;
        this.maxTime = Math.max(this.maxTime, curTime);
    }

    protected void updateMinTime(long curTime) {
        this.initResult = true;
        this.minTime = Math.min(this.minTime, curTime);
    }
}

