/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.view.viewExpression.visitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.BinaryViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.leaf.TimeSeriesViewOperand;
import org.apache.iotdb.commons.schema.view.viewExpression.multi.FunctionViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.ternary.TernaryViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.unary.UnaryViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.visitor.ViewExpressionVisitor;

public class GetSourcePathsVisitor
extends ViewExpressionVisitor<List<PartialPath>, Void> {
    public static List<PartialPath> getSourcePaths(ViewExpression viewExpression) {
        return (List)new GetSourcePathsVisitor().process(viewExpression, null);
    }

    public List<PartialPath> visitExpression(ViewExpression expression, Void context) {
        return new ArrayList<PartialPath>();
    }

    public List<PartialPath> visitTimeSeriesOperand(TimeSeriesViewOperand timeSeriesOperand, Void context) {
        String pathString = timeSeriesOperand.getPathString();
        try {
            PartialPath path = new PartialPath(pathString);
            return Collections.singletonList(path);
        }
        catch (IllegalPathException e) {
            throw new RuntimeException(e);
        }
    }

    public List<PartialPath> visitUnaryExpression(UnaryViewExpression unaryViewExpression, Void context) {
        ViewExpression expression = unaryViewExpression.getExpression();
        return (List)this.process(expression, null);
    }

    public List<PartialPath> visitBinaryExpression(BinaryViewExpression binaryViewExpression, Void context) {
        ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        List expressionList = binaryViewExpression.getChildViewExpressions();
        for (ViewExpression expression : expressionList) {
            result.addAll((Collection)this.process(expression, null));
        }
        return result;
    }

    public List<PartialPath> visitTernaryExpression(TernaryViewExpression ternaryViewExpression, Void context) {
        ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        List expressionList = ternaryViewExpression.getChildViewExpressions();
        for (ViewExpression expression : expressionList) {
            result.addAll((Collection)this.process(expression, null));
        }
        return result;
    }

    public List<PartialPath> visitFunctionExpression(FunctionViewExpression functionViewExpression, Void context) {
        ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        List expressionList = functionViewExpression.getChildViewExpressions();
        for (ViewExpression expression : expressionList) {
            result.addAll((Collection)this.process(expression, null));
        }
        return result;
    }
}

