/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.utils;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.exception.metadata.IllegalParameterOfPathException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaFormatUtils {
    private static final Logger logger = LoggerFactory.getLogger(MetaFormatUtils.class);
    public static String[] RESERVED_NODE_NAMES = new String[]{"time", "timestamp"};

    public static void checkTimeseries(PartialPath timeseries) throws IllegalPathException {
        try {
            MetaFormatUtils.checkCharacters(timeseries.getFullPath());
        }
        catch (MetadataException e) {
            throw new IllegalPathException(timeseries.getFullPath(), e.getMessage());
        }
        for (String name : timeseries.getNodes()) {
            try {
                MetaFormatUtils.checkNameFormat(name);
                MetaFormatUtils.checkReservedNames(name);
            }
            catch (MetadataException e) {
                throw new IllegalPathException(timeseries.getFullPath(), e.getMessage());
            }
        }
    }

    private static void checkNameFormat(String name) throws MetadataException {
        if (!(name.startsWith("`") && name.endsWith("`") || !name.contains(".") && !name.contains("*"))) {
            throw new MetadataException(String.format("%s is an illegal name.", name));
        }
    }

    private static void checkCharacters(String timeseries) throws MetadataException {
        if (!IoTDBConfig.NODE_PATTERN.matcher(timeseries).matches()) {
            throw new MetadataException(String.format("The name, %s, contains unsupported character.", timeseries));
        }
    }

    private static void checkReservedNames(String name) throws MetadataException {
        String processedName = name.trim().toLowerCase(Locale.ENGLISH);
        for (String reservedName : RESERVED_NODE_NAMES) {
            if (!reservedName.equals(processedName)) continue;
            throw new MetadataException(String.format("%s is an illegal name.", name));
        }
    }

    public static void checkNodeName(String name) throws MetadataException {
        MetaFormatUtils.checkCharacters(name);
        MetaFormatUtils.checkReservedNames(name);
        MetaFormatUtils.checkNameFormat(name);
    }

    public static void checkSchemaMeasurementNames(List<String> measurements) throws MetadataException {
        for (String measurement : measurements) {
            MetaFormatUtils.checkNodeName(measurement);
        }
    }

    public static void checkDatabase(String database) throws IllegalPathException {
        if (!IoTDBConfig.STORAGE_GROUP_PATTERN.matcher(database).matches()) {
            throw new IllegalPathException(String.format("The database name can only be characters, numbers and underscores. %s", database));
        }
    }

    public static void checkTimeseriesProps(String path, Map<String, String> props) throws IllegalParameterOfPathException {
        if (props != null && props.containsKey("loss") && props.get("loss").equals("sdt")) {
            MetaFormatUtils.checkSDTFormat(path, props);
        }
    }

    private static void checkSDTFormat(String path, Map<String, String> props) throws IllegalParameterOfPathException {
        if (!props.containsKey("compdev")) {
            throw new IllegalParameterOfPathException("SDT compression deviation is required", path);
        }
        try {
            double d = Double.parseDouble(props.get("compdev"));
            if (d < 0.0) {
                throw new IllegalParameterOfPathException("SDT compression deviation cannot be negative", path);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalParameterOfPathException("SDT compression deviation formatting error", path);
        }
        long compMinTime = MetaFormatUtils.sdtCompressionTimeFormat("compmintime", props, path);
        long compMaxTime = MetaFormatUtils.sdtCompressionTimeFormat("compmaxtime", props, path);
        if (compMaxTime <= compMinTime) {
            throw new IllegalParameterOfPathException("SDT compression maximum time needs to be greater than compression minimum time", path);
        }
    }

    private static long sdtCompressionTimeFormat(String compTime, Map<String, String> props, String path) throws IllegalParameterOfPathException {
        long time;
        block4: {
            String s;
            boolean isCompMaxTime = compTime.equals("compmaxtime");
            time = isCompMaxTime ? Long.MAX_VALUE : 0L;
            String string = s = isCompMaxTime ? "maximum" : "minimum";
            if (props.containsKey(compTime)) {
                try {
                    time = Long.parseLong(props.get(compTime));
                    if (time < 0L) {
                        throw new IllegalParameterOfPathException(String.format("SDT compression %s time cannot be negative", s), path);
                    }
                    break block4;
                }
                catch (IllegalParameterOfPathException e) {
                    throw new IllegalParameterOfPathException(String.format("SDT compression %s time formatting error", s), path);
                }
            }
            logger.info("{} enabled SDT but did not set compression {} time", (Object)path, (Object)s);
        }
        return time;
    }
}

