/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store;

import java.io.File;
import java.util.Map;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeIterator;
import org.apache.iotdb.db.metadata.template.Template;

public interface IMTreeStore<N extends IMNode<N>> {
    public N generatePrefix(PartialPath var1);

    public N getRoot();

    public boolean hasChild(N var1, String var2) throws MetadataException;

    public N getChild(N var1, String var2) throws MetadataException;

    public IMNodeIterator<N> getChildrenIterator(N var1) throws MetadataException;

    public IMNodeIterator<N> getTraverserIterator(N var1, Map<Integer, Template> var2, boolean var3) throws MetadataException;

    public N addChild(N var1, String var2, N var3);

    public void deleteChild(N var1, String var2) throws MetadataException;

    public void updateMNode(N var1) throws MetadataException;

    public IDeviceMNode<N> setToEntity(N var1) throws MetadataException;

    public N setToInternal(IDeviceMNode<N> var1) throws MetadataException;

    public void setAlias(IMeasurementMNode<N> var1, String var2) throws MetadataException;

    public void pin(N var1) throws MetadataException;

    public void unPin(N var1);

    public void unPinPath(N var1);

    public IMTreeStore<N> getWithReentrantReadLock();

    public void clear();

    public boolean createSnapshot(File var1);
}

