/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.snapshot;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.common.AbstractDatabaseDeviceMNode;
import org.apache.iotdb.commons.schema.node.common.AbstractDatabaseMNode;
import org.apache.iotdb.commons.schema.node.common.AbstractDeviceMNode;
import org.apache.iotdb.commons.schema.node.common.AbstractMeasurementMNode;
import org.apache.iotdb.commons.schema.node.info.IMeasurementInfo;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.commons.schema.node.utils.IMNodeIterator;
import org.apache.iotdb.commons.schema.node.visitor.MNodeVisitor;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.db.metadata.MetadataConstant;
import org.apache.iotdb.db.metadata.mnode.mem.IMemMNode;
import org.apache.iotdb.db.metadata.mnode.mem.info.LogicalViewInfo;
import org.apache.iotdb.db.metadata.mnode.utils.MNodeFactoryLoader;
import org.apache.iotdb.db.metadata.mtree.store.MemMTreeStore;
import org.apache.iotdb.db.metadata.rescon.MemSchemaRegionStatistics;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemMTreeSnapshotUtil {
    private static final Logger logger = LoggerFactory.getLogger(MemMTreeSnapshotUtil.class);
    private static final String SERIALIZE_ERROR_INFO = "Error occurred during serializing MemMTree.";
    private static final String DESERIALIZE_ERROR_INFO = "Error occurred during deserializing MemMTree.";
    private static final byte VERSION = 0;
    private static final IMNodeFactory<IMemMNode> nodeFactory = MNodeFactoryLoader.getInstance().getMemMNodeIMNodeFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createSnapshot(File snapshotDir, MemMTreeStore store) {
        File snapshotTmp = SystemFileFactory.INSTANCE.getFile(snapshotDir, "mtree.snapshot.tmp");
        File snapshot = SystemFileFactory.INSTANCE.getFile(snapshotDir, "mtree.snapshot");
        try {
            try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(snapshotTmp));){
                MemMTreeSnapshotUtil.serializeTo(store, outputStream);
            }
            if (snapshot.exists() && !snapshot.delete()) {
                logger.error("Failed to delete old snapshot {} while creating mtree snapshot.", (Object)snapshot.getName());
                boolean outputStream = false;
                return outputStream;
            }
            if (!snapshotTmp.renameTo(snapshot)) {
                logger.error("Failed to rename {} to {} while creating mtree snapshot.", (Object)snapshotTmp.getName(), (Object)snapshot.getName());
                snapshot.delete();
                boolean outputStream = false;
                return outputStream;
            }
            boolean outputStream = true;
            return outputStream;
        }
        catch (IOException e) {
            logger.error("Failed to create mtree snapshot due to {}", (Object)e.getMessage(), (Object)e);
            snapshot.delete();
            boolean bl = false;
            return bl;
        }
        finally {
            snapshotTmp.delete();
        }
    }

    public static IMemMNode loadSnapshot(File snapshotDir, Consumer<IMeasurementMNode<IMemMNode>> measurementProcess, Consumer<IDeviceMNode<IMemMNode>> deviceProcess, MemSchemaRegionStatistics regionStatistics) throws IOException {
        IMemMNode iMemMNode;
        File snapshot = SystemFileFactory.INSTANCE.getFile(snapshotDir, "mtree.snapshot");
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(snapshot));
        try {
            iMemMNode = MemMTreeSnapshotUtil.deserializeFrom(inputStream, measurementProcess, deviceProcess, regionStatistics);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                regionStatistics.clear();
                throw e;
            }
        }
        inputStream.close();
        return iMemMNode;
    }

    private static void serializeTo(MemMTreeStore store, OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((byte)0, (OutputStream)outputStream);
        MemMTreeSnapshotUtil.inorderSerialize(store.getRoot(), store, outputStream);
    }

    private static void inorderSerialize(IMemMNode root, MemMTreeStore store, OutputStream outputStream) throws IOException {
        MNodeSerializer serializer = new MNodeSerializer();
        if (!((Boolean)root.accept(serializer, outputStream)).booleanValue()) {
            throw new IOException(SERIALIZE_ERROR_INFO);
        }
        ArrayDeque<IMNodeIterator<IMemMNode>> stack = new ArrayDeque<IMNodeIterator<IMemMNode>>();
        stack.push(store.getChildrenIterator(root));
        while (!stack.isEmpty()) {
            IMNodeIterator iterator = (IMNodeIterator)stack.peek();
            if (iterator.hasNext()) {
                IMemMNode node = (IMemMNode)iterator.next();
                if (!((Boolean)node.accept(serializer, outputStream)).booleanValue()) {
                    throw new IOException(SERIALIZE_ERROR_INFO);
                }
                if (node.isMeasurement()) continue;
                stack.push(store.getChildrenIterator(node));
                continue;
            }
            stack.pop();
        }
    }

    private static IMemMNode deserializeFrom(InputStream inputStream, Consumer<IMeasurementMNode<IMemMNode>> measurementProcess, Consumer<IDeviceMNode<IMemMNode>> deviceProcess, MemSchemaRegionStatistics regionStatistics) throws IOException {
        byte version = ReadWriteIOUtils.readByte((InputStream)inputStream);
        return MemMTreeSnapshotUtil.inorderDeserialize(inputStream, measurementProcess, deviceProcess, regionStatistics);
    }

    private static IMemMNode inorderDeserialize(InputStream inputStream, Consumer<IMeasurementMNode<IMemMNode>> measurementProcess, Consumer<IDeviceMNode<IMemMNode>> deviceProcess, MemSchemaRegionStatistics regionStatistics) throws IOException {
        MNodeDeserializer deserializer = new MNodeDeserializer();
        ArrayDeque<IMemMNode> ancestors = new ArrayDeque<IMemMNode>();
        ArrayDeque<Integer> restChildrenNum = new ArrayDeque<Integer>();
        MemMTreeSnapshotUtil.deserializeMNode(ancestors, restChildrenNum, deserializer, inputStream, measurementProcess, deviceProcess, regionStatistics);
        IMemMNode root = (IMemMNode)ancestors.peek();
        while (!ancestors.isEmpty()) {
            int childrenNum = (Integer)restChildrenNum.pop();
            if (childrenNum == 0) {
                ancestors.pop();
                continue;
            }
            restChildrenNum.push(childrenNum - 1);
            MemMTreeSnapshotUtil.deserializeMNode(ancestors, restChildrenNum, deserializer, inputStream, measurementProcess, deviceProcess, regionStatistics);
        }
        return root;
    }

    private static void deserializeMNode(Deque<IMemMNode> ancestors, Deque<Integer> restChildrenNum, MNodeDeserializer deserializer, InputStream inputStream, Consumer<IMeasurementMNode<IMemMNode>> measurementProcess, Consumer<IDeviceMNode<IMemMNode>> deviceProcess, MemSchemaRegionStatistics regionStatistics) throws IOException {
        IMemMNode node;
        int childrenNum;
        byte type = ReadWriteIOUtils.readByte((InputStream)inputStream);
        switch (type) {
            case 0: {
                childrenNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
                node = deserializer.deserializeInternalMNode(inputStream);
                break;
            }
            case 1: {
                childrenNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
                node = deserializer.deserializeStorageGroupMNode(inputStream);
                break;
            }
            case 3: {
                childrenNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
                node = deserializer.deserializeEntityMNode(inputStream);
                deviceProcess.accept((IDeviceMNode<IMemMNode>)node.getAsDeviceMNode());
                break;
            }
            case 4: {
                childrenNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
                node = deserializer.deserializeStorageGroupEntityMNode(inputStream);
                deviceProcess.accept((IDeviceMNode<IMemMNode>)node.getAsDeviceMNode());
                break;
            }
            case 2: {
                childrenNum = 0;
                node = deserializer.deserializeMeasurementMNode(inputStream);
                measurementProcess.accept((IMeasurementMNode<IMemMNode>)node.getAsMeasurementMNode());
                break;
            }
            case 5: {
                childrenNum = 0;
                node = deserializer.deserializeLogicalViewMNode(inputStream);
                measurementProcess.accept((IMeasurementMNode<IMemMNode>)node.getAsMeasurementMNode());
                break;
            }
            default: {
                throw new IOException("Unrecognized MNode type " + type);
            }
        }
        regionStatistics.requestMemory(node.estimateSize());
        if (!ancestors.isEmpty()) {
            node.setParent(ancestors.peek());
            ancestors.peek().addChild(node);
            if (node.isMeasurement() && node.getAsMeasurementMNode().getAlias() != null) {
                ancestors.peek().getAsDeviceMNode().addAlias(node.getAsMeasurementMNode().getAlias(), node.getAsMeasurementMNode());
            }
        }
        if (childrenNum > 0 || MetadataConstant.isStorageGroupType(type)) {
            ancestors.push(node);
            restChildrenNum.push(childrenNum);
        }
    }

    private static class MNodeDeserializer {
        private MNodeDeserializer() {
        }

        public IMemMNode deserializeInternalMNode(InputStream inputStream) throws IOException {
            String name = ReadWriteIOUtils.readString((InputStream)inputStream);
            IMemMNode node = (IMemMNode)nodeFactory.createInternalMNode(null, name);
            int templateId = ReadWriteIOUtils.readInt((InputStream)inputStream);
            boolean useTemplate = ReadWriteIOUtils.readBool((InputStream)inputStream);
            return node;
        }

        public IMemMNode deserializeStorageGroupMNode(InputStream inputStream) throws IOException {
            String name = ReadWriteIOUtils.readString((InputStream)inputStream);
            IMemMNode node = (IMemMNode)nodeFactory.createDatabaseMNode(null, name).getAsMNode();
            int templateId = ReadWriteIOUtils.readInt((InputStream)inputStream);
            boolean useTemplate = ReadWriteIOUtils.readBool((InputStream)inputStream);
            return node;
        }

        public IMemMNode deserializeStorageGroupEntityMNode(InputStream inputStream) throws IOException {
            String name = ReadWriteIOUtils.readString((InputStream)inputStream);
            IMemMNode node = (IMemMNode)nodeFactory.createDatabaseDeviceMNode(null, name, 0L);
            node.getAsDeviceMNode().setSchemaTemplateId(ReadWriteIOUtils.readInt((InputStream)inputStream));
            node.getAsDeviceMNode().setUseTemplate(ReadWriteIOUtils.readBool((InputStream)inputStream));
            node.getAsDeviceMNode().setAligned(ReadWriteIOUtils.readBoolObject((InputStream)inputStream));
            return node;
        }

        public IMemMNode deserializeEntityMNode(InputStream inputStream) throws IOException {
            String name = ReadWriteIOUtils.readString((InputStream)inputStream);
            IDeviceMNode node = nodeFactory.createDeviceMNode(null, name);
            node.setSchemaTemplateId(ReadWriteIOUtils.readInt((InputStream)inputStream));
            node.setUseTemplate(ReadWriteIOUtils.readBool((InputStream)inputStream));
            node.setAligned(ReadWriteIOUtils.readBoolObject((InputStream)inputStream));
            return (IMemMNode)node.getAsMNode();
        }

        public IMemMNode deserializeMeasurementMNode(InputStream inputStream) throws IOException {
            String name = ReadWriteIOUtils.readString((InputStream)inputStream);
            MeasurementSchema schema = MeasurementSchema.deserializeFrom((InputStream)inputStream);
            String alias = ReadWriteIOUtils.readString((InputStream)inputStream);
            long tagOffset = ReadWriteIOUtils.readLong((InputStream)inputStream);
            IMeasurementMNode node = nodeFactory.createMeasurementMNode(null, name, (IMeasurementSchema)schema, alias);
            node.setOffset(tagOffset);
            node.setPreDeleted(ReadWriteIOUtils.readBool((InputStream)inputStream));
            return (IMemMNode)node.getAsMNode();
        }

        public IMemMNode deserializeLogicalViewMNode(InputStream inputStream) throws IOException {
            String name = ReadWriteIOUtils.readString((InputStream)inputStream);
            LogicalViewSchema logicalViewSchema = LogicalViewSchema.deserializeFrom((InputStream)inputStream);
            long tagOffset = ReadWriteIOUtils.readLong((InputStream)inputStream);
            IMeasurementMNode node = nodeFactory.createLogicalViewMNode(null, name, (IMeasurementInfo)new LogicalViewInfo(logicalViewSchema));
            node.setOffset(tagOffset);
            node.setPreDeleted(ReadWriteIOUtils.readBool((InputStream)inputStream));
            return (IMemMNode)node.getAsMNode();
        }
    }

    private static class MNodeSerializer
    extends MNodeVisitor<Boolean, OutputStream> {
        private MNodeSerializer() {
        }

        public Boolean visitBasicMNode(IMNode<?> node, OutputStream outputStream) {
            try {
                ReadWriteIOUtils.write((byte)0, (OutputStream)outputStream);
                this.serializeBasicMNode(node, outputStream);
                ReadWriteIOUtils.write((int)0, (OutputStream)outputStream);
                ReadWriteIOUtils.write((Boolean)false, (OutputStream)outputStream);
                return true;
            }
            catch (IOException e) {
                logger.error(MemMTreeSnapshotUtil.SERIALIZE_ERROR_INFO, (Throwable)e);
                return false;
            }
        }

        public Boolean visitDatabaseMNode(AbstractDatabaseMNode<?, ? extends IMNode<?>> node, OutputStream outputStream) {
            try {
                ReadWriteIOUtils.write((byte)1, (OutputStream)outputStream);
                this.serializeBasicMNode(node.getBasicMNode(), outputStream);
                ReadWriteIOUtils.write((int)0, (OutputStream)outputStream);
                ReadWriteIOUtils.write((Boolean)false, (OutputStream)outputStream);
                return true;
            }
            catch (IOException e) {
                logger.error(MemMTreeSnapshotUtil.SERIALIZE_ERROR_INFO, (Throwable)e);
                return false;
            }
        }

        public Boolean visitDatabaseDeviceMNode(AbstractDatabaseDeviceMNode<?, ? extends IMNode<?>> node, OutputStream outputStream) {
            try {
                ReadWriteIOUtils.write((byte)4, (OutputStream)outputStream);
                this.serializeBasicMNode(node.getBasicMNode(), outputStream);
                ReadWriteIOUtils.write((int)node.getSchemaTemplateIdWithState(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((Boolean)node.isUseTemplate(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((Boolean)node.isAlignedNullable(), (OutputStream)outputStream);
                return true;
            }
            catch (IOException e) {
                logger.error(MemMTreeSnapshotUtil.SERIALIZE_ERROR_INFO, (Throwable)e);
                return false;
            }
        }

        public Boolean visitDeviceMNode(AbstractDeviceMNode<?, ? extends IMNode<?>> node, OutputStream outputStream) {
            try {
                ReadWriteIOUtils.write((byte)3, (OutputStream)outputStream);
                this.serializeBasicMNode(node.getBasicMNode(), outputStream);
                ReadWriteIOUtils.write((int)node.getSchemaTemplateIdWithState(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((Boolean)node.isUseTemplate(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((Boolean)node.isAlignedNullable(), (OutputStream)outputStream);
                return true;
            }
            catch (IOException e) {
                logger.error(MemMTreeSnapshotUtil.SERIALIZE_ERROR_INFO, (Throwable)e);
                return false;
            }
        }

        public Boolean visitMeasurementMNode(AbstractMeasurementMNode<?, ? extends IMNode<?>> node, OutputStream outputStream) {
            try {
                if (node.isLogicalView()) {
                    ReadWriteIOUtils.write((byte)5, (OutputStream)outputStream);
                    ReadWriteIOUtils.write((String)node.getName(), (OutputStream)outputStream);
                    node.getSchema().serializeTo(outputStream);
                    ReadWriteIOUtils.write((long)node.getOffset(), (OutputStream)outputStream);
                    ReadWriteIOUtils.write((Boolean)node.isPreDeleted(), (OutputStream)outputStream);
                } else {
                    ReadWriteIOUtils.write((byte)2, (OutputStream)outputStream);
                    ReadWriteIOUtils.write((String)node.getName(), (OutputStream)outputStream);
                    node.getSchema().serializeTo(outputStream);
                    ReadWriteIOUtils.write((String)node.getAlias(), (OutputStream)outputStream);
                    ReadWriteIOUtils.write((long)node.getOffset(), (OutputStream)outputStream);
                    ReadWriteIOUtils.write((Boolean)node.isPreDeleted(), (OutputStream)outputStream);
                }
                return true;
            }
            catch (Exception e) {
                logger.error(MemMTreeSnapshotUtil.SERIALIZE_ERROR_INFO, (Throwable)e);
                return false;
            }
        }

        private void serializeBasicMNode(IMNode<?> node, OutputStream outputStream) throws IOException {
            ReadWriteIOUtils.write((int)node.getChildren().size(), (OutputStream)outputStream);
            ReadWriteIOUtils.write((String)node.getName(), (OutputStream)outputStream);
        }
    }
}

