/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode.schemafile.basic;

import java.util.ArrayList;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.MNodeType;
import org.apache.iotdb.commons.schema.node.role.IDatabaseMNode;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeContainer;
import org.apache.iotdb.commons.schema.node.visitor.MNodeVisitor;
import org.apache.iotdb.db.metadata.mnode.schemafile.ICachedMNode;
import org.apache.iotdb.db.metadata.mnode.schemafile.container.CachedMNodeContainer;
import org.apache.iotdb.db.metadata.mnode.schemafile.info.CacheMNodeInfo;
import org.apache.iotdb.db.metadata.mtree.store.disk.cache.CacheEntry;

public class CachedBasicMNode
implements ICachedMNode {
    private static final long serialVersionUID = -770028375899514063L;
    private ICachedMNode parent;
    private final CacheMNodeInfo cacheMNodeInfo;
    private String fullPath;

    public CachedBasicMNode(ICachedMNode parent, String name) {
        this.parent = parent;
        this.cacheMNodeInfo = new CacheMNodeInfo(name);
    }

    public String getName() {
        return this.cacheMNodeInfo.getName();
    }

    public void setName(String name) {
        this.cacheMNodeInfo.setName(name);
    }

    public ICachedMNode getParent() {
        return this.parent;
    }

    public void setParent(ICachedMNode parent) {
        this.parent = parent;
    }

    public String getFullPath() {
        if (this.fullPath == null) {
            this.fullPath = this.concatFullPath();
        }
        return this.fullPath;
    }

    String concatFullPath() {
        StringBuilder builder = new StringBuilder(this.getName());
        ICachedMNode curr = this;
        while (curr.getParent() != null) {
            curr = (ICachedMNode)curr.getParent();
            builder.insert(0, '.').insert(0, curr.getName());
        }
        return builder.toString();
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public PartialPath getPartialPath() {
        ArrayList<String> detachedPath = new ArrayList<String>();
        ICachedMNode temp = this;
        detachedPath.add(temp.getName());
        while (temp.getParent() != null) {
            temp = (ICachedMNode)temp.getParent();
            detachedPath.add(0, temp.getName());
        }
        return new PartialPath(detachedPath.toArray(new String[0]));
    }

    public boolean hasChild(String name) {
        return false;
    }

    public ICachedMNode getChild(String name) {
        return null;
    }

    public ICachedMNode addChild(String name, ICachedMNode child) {
        return null;
    }

    public ICachedMNode addChild(ICachedMNode child) {
        return null;
    }

    public ICachedMNode deleteChild(String name) {
        return null;
    }

    public synchronized void replaceChild(String oldChildName, ICachedMNode newChildNode) {
    }

    public void moveDataToNewMNode(ICachedMNode newMNode) {
        newMNode.setParent(this.parent);
        newMNode.setCacheEntry(this.getCacheEntry());
    }

    public IMNodeContainer<ICachedMNode> getChildren() {
        return CachedMNodeContainer.emptyMNodeContainer();
    }

    public void setChildren(IMNodeContainer<ICachedMNode> children) {
    }

    public boolean isAboveDatabase() {
        return false;
    }

    public boolean isDatabase() {
        return false;
    }

    public boolean isDevice() {
        return false;
    }

    public boolean isMeasurement() {
        return false;
    }

    public MNodeType getMNodeType(Boolean isConfig) {
        return isConfig != false ? MNodeType.SG_INTERNAL : MNodeType.INTERNAL;
    }

    public IDatabaseMNode<ICachedMNode> getAsDatabaseMNode() {
        throw new UnsupportedOperationException("Wrong MNode Type");
    }

    public IDeviceMNode<ICachedMNode> getAsDeviceMNode() {
        throw new UnsupportedOperationException("Wrong MNode Type");
    }

    public IMeasurementMNode<ICachedMNode> getAsMeasurementMNode() {
        throw new UnsupportedOperationException("Wrong MNode Type");
    }

    public <R, C> R accept(MNodeVisitor<R, C> visitor, C context) {
        return (R)visitor.visitBasicMNode((IMNode)this, context);
    }

    @Override
    public CacheEntry getCacheEntry() {
        return this.cacheMNodeInfo.getCacheEntry();
    }

    @Override
    public void setCacheEntry(CacheEntry cacheEntry) {
        this.cacheMNodeInfo.setCacheEntry(cacheEntry);
    }

    public int estimateSize() {
        return 76 + this.cacheMNodeInfo.estimateSize();
    }

    public ICachedMNode getAsMNode() {
        return this;
    }
}

