/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.execute.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.compaction.io.CompactionTsFileReader;
import org.apache.iotdb.db.engine.compaction.schedule.constant.CompactionType;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.read.TsFileDeviceIterator;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class MultiTsFileDeviceIterator
implements AutoCloseable {
    private final List<TsFileResource> tsFileResourcesSortedByDesc;
    private List<TsFileResource> tsFileResourcesSortedByAsc;
    private Map<TsFileResource, TsFileSequenceReader> readerMap = new HashMap<TsFileResource, TsFileSequenceReader>();
    private final Map<TsFileResource, TsFileDeviceIterator> deviceIteratorMap = new HashMap<TsFileResource, TsFileDeviceIterator>();
    private final Map<TsFileResource, List<Modification>> modificationCache = new HashMap<TsFileResource, List<Modification>>();
    private Pair<String, Boolean> currentDevice = null;

    public MultiTsFileDeviceIterator(List<TsFileResource> tsFileResources) throws IOException {
        this.tsFileResourcesSortedByDesc = new ArrayList<TsFileResource>(tsFileResources);
        this.tsFileResourcesSortedByAsc = new ArrayList<TsFileResource>(tsFileResources);
        Collections.sort(this.tsFileResourcesSortedByAsc, TsFileResource::compareFileName);
        Collections.sort(this.tsFileResourcesSortedByDesc, TsFileResource::compareFileCreationOrderByDesc);
        try {
            for (TsFileResource tsFileResource : this.tsFileResourcesSortedByDesc) {
                CompactionTsFileReader reader = new CompactionTsFileReader(tsFileResource.getTsFilePath(), CompactionType.INNER_SEQ_COMPACTION);
                this.readerMap.put(tsFileResource, reader);
                this.deviceIteratorMap.put(tsFileResource, reader.getAllDevicesIteratorWithIsAligned());
            }
        }
        catch (Throwable throwable) {
            for (TsFileSequenceReader reader : this.readerMap.values()) {
                reader.close();
            }
            throw throwable;
        }
    }

    public MultiTsFileDeviceIterator(List<TsFileResource> seqResources, List<TsFileResource> unseqResources) throws IOException {
        this.tsFileResourcesSortedByDesc = new ArrayList<TsFileResource>(seqResources);
        this.tsFileResourcesSortedByDesc.addAll(unseqResources);
        Collections.sort(this.tsFileResourcesSortedByDesc, TsFileResource::compareFileCreationOrderByDesc);
        for (TsFileResource tsFileResource : this.tsFileResourcesSortedByDesc) {
            TsFileSequenceReader reader = FileReaderManager.getInstance().get(tsFileResource.getTsFilePath(), true);
            this.readerMap.put(tsFileResource, reader);
            this.deviceIteratorMap.put(tsFileResource, reader.getAllDevicesIteratorWithIsAligned());
        }
    }

    public MultiTsFileDeviceIterator(List<TsFileResource> seqResources, List<TsFileResource> unseqResources, Map<TsFileResource, TsFileSequenceReader> readerMap) throws IOException {
        this.tsFileResourcesSortedByDesc = new ArrayList<TsFileResource>(seqResources);
        this.tsFileResourcesSortedByDesc.addAll(unseqResources);
        Collections.sort(this.tsFileResourcesSortedByDesc, TsFileResource::compareFileCreationOrderByDesc);
        this.readerMap = readerMap;
        CompactionType type = null;
        type = !seqResources.isEmpty() && !unseqResources.isEmpty() ? CompactionType.CROSS_COMPACTION : (seqResources.isEmpty() ? CompactionType.INNER_UNSEQ_COMPACTION : CompactionType.INNER_SEQ_COMPACTION);
        for (TsFileResource tsFileResource : this.tsFileResourcesSortedByDesc) {
            CompactionTsFileReader reader = new CompactionTsFileReader(tsFileResource.getTsFilePath(), type);
            readerMap.put(tsFileResource, reader);
            this.deviceIteratorMap.put(tsFileResource, reader.getAllDevicesIteratorWithIsAligned());
        }
    }

    public boolean hasNextDevice() {
        boolean hasNext = false;
        for (TsFileDeviceIterator iterator : this.deviceIteratorMap.values()) {
            hasNext = hasNext || iterator.hasNext() || iterator.current() != null && !((String)iterator.current().left).equals(this.currentDevice.left);
        }
        return hasNext;
    }

    public Pair<String, Boolean> nextDevice() {
        LinkedList<TsFileResource> toBeRemovedResources = new LinkedList<TsFileResource>();
        Pair minDevice = null;
        for (TsFileResource resource : this.tsFileResourcesSortedByDesc) {
            if (!this.deviceIteratorMap.containsKey(resource)) continue;
            TsFileDeviceIterator deviceIterator = this.deviceIteratorMap.get(resource);
            if (deviceIterator.current() == null || ((String)deviceIterator.current().left).equals(this.currentDevice.left)) {
                if (deviceIterator.hasNext()) {
                    deviceIterator.next();
                } else {
                    toBeRemovedResources.add(resource);
                    continue;
                }
            }
            if (minDevice != null && ((String)minDevice.left).compareTo((String)deviceIterator.current().left) <= 0) continue;
            minDevice = deviceIterator.current();
        }
        this.currentDevice = minDevice;
        for (TsFileResource resource : toBeRemovedResources) {
            this.deviceIteratorMap.remove(resource);
        }
        return this.currentDevice;
    }

    public Map<String, MeasurementSchema> getAllSchemasOfCurrentDevice() throws IOException {
        ConcurrentHashMap<String, MeasurementSchema> schemaMap = new ConcurrentHashMap<String, MeasurementSchema>();
        for (TsFileResource resource : this.tsFileResourcesSortedByDesc) {
            if (!this.deviceIteratorMap.containsKey(resource) || !this.deviceIteratorMap.get(resource).current().equals(this.currentDevice)) continue;
            TsFileSequenceReader reader = this.readerMap.get(resource);
            ArrayList timeseriesMetadataList = new ArrayList();
            reader.getDeviceTimeseriesMetadata(timeseriesMetadataList, this.deviceIteratorMap.get(resource).getFirstMeasurementNodeOfCurrentDevice(), schemaMap.keySet(), true);
            for (TimeseriesMetadata timeseriesMetadata : timeseriesMetadataList) {
                if (schemaMap.containsKey(timeseriesMetadata.getMeasurementId()) || timeseriesMetadata.getChunkMetadataList().isEmpty()) continue;
                schemaMap.put(timeseriesMetadata.getMeasurementId(), reader.getMeasurementSchema(timeseriesMetadata.getChunkMetadataList()));
            }
        }
        return schemaMap;
    }

    public Map<String, Map<TsFileResource, Pair<Long, Long>>> getTimeseriesMetadataOffsetOfCurrentDevice() throws IOException {
        HashMap<String, Map<TsFileResource, Pair<Long, Long>>> timeseriesMetadataOffsetMap = new HashMap<String, Map<TsFileResource, Pair<Long, Long>>>();
        for (TsFileResource resource : this.tsFileResourcesSortedByDesc) {
            if (!this.deviceIteratorMap.containsKey(resource) || !this.deviceIteratorMap.get(resource).current().equals(this.currentDevice)) continue;
            TsFileSequenceReader reader = this.readerMap.get(resource);
            for (Map.Entry entrySet : reader.getTimeseriesMetadataOffsetByDevice(this.deviceIteratorMap.get(resource).getFirstMeasurementNodeOfCurrentDevice(), Collections.emptySet(), false).entrySet()) {
                String measurementId = (String)entrySet.getKey();
                if (!timeseriesMetadataOffsetMap.containsKey(measurementId)) {
                    timeseriesMetadataOffsetMap.put(measurementId, new HashMap());
                }
                ((Map)timeseriesMetadataOffsetMap.get(measurementId)).put(resource, (Pair)((Pair)entrySet.getValue()).right);
            }
        }
        return timeseriesMetadataOffsetMap;
    }

    public Map<String, Pair<MeasurementSchema, Map<TsFileResource, Pair<Long, Long>>>> getTimeseriesSchemaAndMetadataOffsetOfCurrentDevice() throws IOException {
        LinkedHashMap<String, Pair<MeasurementSchema, Map<TsFileResource, Pair<Long, Long>>>> timeseriesMetadataOffsetMap = new LinkedHashMap<String, Pair<MeasurementSchema, Map<TsFileResource, Pair<Long, Long>>>>();
        for (TsFileResource resource : this.tsFileResourcesSortedByDesc) {
            if (!this.deviceIteratorMap.containsKey(resource) || !this.deviceIteratorMap.get(resource).current().equals(this.currentDevice)) continue;
            TsFileSequenceReader reader = this.readerMap.get(resource);
            for (Map.Entry entrySet : reader.getTimeseriesMetadataOffsetByDevice(this.deviceIteratorMap.get(resource).getFirstMeasurementNodeOfCurrentDevice(), timeseriesMetadataOffsetMap.keySet(), true).entrySet()) {
                String measurementId = (String)entrySet.getKey();
                if (!timeseriesMetadataOffsetMap.containsKey(measurementId)) {
                    MeasurementSchema schema = reader.getMeasurementSchema((List)((Pair)entrySet.getValue()).left);
                    timeseriesMetadataOffsetMap.put(measurementId, (Pair<MeasurementSchema, Map<TsFileResource, Pair<Long, Long>>>)new Pair((Object)schema, new HashMap()));
                }
                ((Map)((Pair)timeseriesMetadataOffsetMap.get((Object)measurementId)).right).put(resource, (Pair)((Pair)entrySet.getValue()).right);
            }
        }
        return timeseriesMetadataOffsetMap;
    }

    public MeasurementIterator iterateNotAlignedSeries(String device, boolean derserializeTimeseriesMetadata) throws IOException {
        return new MeasurementIterator(this.readerMap, device, derserializeTimeseriesMetadata);
    }

    public LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> getReaderAndChunkMetadataForCurrentAlignedSeries() throws IOException {
        if (this.currentDevice == null || !((Boolean)this.currentDevice.right).booleanValue()) {
            return null;
        }
        LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> readerAndChunkMetadataList = new LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>>();
        for (TsFileResource tsFileResource : this.tsFileResourcesSortedByAsc) {
            TsFileDeviceIterator iterator;
            if (!this.deviceIteratorMap.containsKey(tsFileResource) || !this.currentDevice.equals((Object)(iterator = this.deviceIteratorMap.get(tsFileResource)).current())) continue;
            TsFileSequenceReader reader = this.readerMap.get(tsFileResource);
            List alignedChunkMetadataList = reader.getAlignedChunkMetadata((String)this.currentDevice.left);
            if (!alignedChunkMetadataList.isEmpty()) {
                alignedChunkMetadataList.forEach(x -> x.setFilePath(tsFileResource.getTsFilePath()));
            }
            this.applyModificationForAlignedChunkMetadataList(tsFileResource, alignedChunkMetadataList);
            readerAndChunkMetadataList.add((Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>)new Pair((Object)reader, (Object)alignedChunkMetadataList));
        }
        return readerAndChunkMetadataList;
    }

    private void applyModificationForAlignedChunkMetadataList(TsFileResource tsFileResource, List<AlignedChunkMetadata> alignedChunkMetadataList) {
        ModificationFile modificationFile = ModificationFile.getNormalMods(tsFileResource);
        if (!modificationFile.exists()) {
            return;
        }
        List modifications = this.modificationCache.computeIfAbsent(tsFileResource, r -> new ArrayList<Modification>(modificationFile.getModifications()));
        AlignedChunkMetadata alignedChunkMetadata = alignedChunkMetadataList.get(0);
        List valueChunkMetadataList = alignedChunkMetadata.getValueChunkMetadataList();
        ArrayList<List<Modification>> modificationForCurDevice = new ArrayList<List<Modification>>();
        for (int i = 0; i < valueChunkMetadataList.size(); ++i) {
            modificationForCurDevice.add(new ArrayList());
        }
        for (Modification modification : modifications) {
            if (!modification.getDevice().equals(this.currentDevice.left)) continue;
            for (int i = 0; i < valueChunkMetadataList.size(); ++i) {
                IChunkMetadata chunkMetadata = (IChunkMetadata)valueChunkMetadataList.get(i);
                if (chunkMetadata == null || !modification.getMeasurement().equals(chunkMetadata.getMeasurementUid())) continue;
                ((List)modificationForCurDevice.get(i)).add(modification);
            }
        }
        ModificationUtils.modifyAlignedChunkMetaData(alignedChunkMetadataList, modificationForCurDevice);
    }

    @Override
    public void close() throws IOException {
        for (TsFileSequenceReader reader : this.readerMap.values()) {
            reader.close();
        }
    }

    public class MeasurementIterator {
        private Map<TsFileResource, TsFileSequenceReader> readerMap;
        private String device;
        private String currentCompactingSeries = null;
        private LinkedList<String> seriesInThisIteration = new LinkedList();
        private Map<TsFileSequenceReader, Map<String, List<ChunkMetadata>>> chunkMetadataCacheMap = new HashMap<TsFileSequenceReader, Map<String, List<ChunkMetadata>>>();
        private Map<TsFileResource, Iterator<Map<String, List<ChunkMetadata>>>> chunkMetadataIteratorMap = new HashMap<TsFileResource, Iterator<Map<String, List<ChunkMetadata>>>>();

        private MeasurementIterator(Map<TsFileResource, TsFileSequenceReader> readerMap, String device, boolean needDeserializeTimeseries) throws IOException {
            this.readerMap = readerMap;
            this.device = device;
            if (needDeserializeTimeseries) {
                for (TsFileResource resource : MultiTsFileDeviceIterator.this.tsFileResourcesSortedByAsc) {
                    TsFileSequenceReader reader = readerMap.get(resource);
                    this.chunkMetadataIteratorMap.put(resource, reader.getMeasurementChunkMetadataListMapIterator(device));
                    this.chunkMetadataCacheMap.put(reader, new TreeMap());
                }
            }
        }

        private boolean collectSeries() {
            String lastSeries = null;
            ArrayList<String> tempCollectedSeries = new ArrayList<String>();
            for (TsFileResource resource : MultiTsFileDeviceIterator.this.tsFileResourcesSortedByAsc) {
                TsFileSequenceReader reader = this.readerMap.get(resource);
                Map<String, List<ChunkMetadata>> chunkMetadataListMap = this.chunkMetadataCacheMap.get(reader);
                if (chunkMetadataListMap.size() == 0) {
                    if (!this.chunkMetadataIteratorMap.get(resource).hasNext()) continue;
                    chunkMetadataListMap = this.chunkMetadataIteratorMap.get(resource).next();
                    if (chunkMetadataListMap.containsKey("")) {
                        chunkMetadataListMap.remove("");
                    }
                    this.chunkMetadataCacheMap.put(reader, chunkMetadataListMap);
                }
                String maxSeries = Collections.max(chunkMetadataListMap.keySet());
                if (lastSeries == null) {
                    lastSeries = maxSeries;
                } else if (maxSeries.compareTo(lastSeries) < 0) {
                    lastSeries = maxSeries;
                }
                tempCollectedSeries.addAll(chunkMetadataListMap.keySet());
            }
            if (!tempCollectedSeries.isEmpty()) {
                if (!this.hasRemainingSeries()) {
                    lastSeries = (String)Collections.max(tempCollectedSeries);
                }
                String finalLastSeries = lastSeries;
                List finalCollectedSeriesInThisIteration = tempCollectedSeries.stream().filter(series -> series.compareTo(finalLastSeries) <= 0).collect(Collectors.toList());
                this.seriesInThisIteration.addAll(finalCollectedSeriesInThisIteration);
                return true;
            }
            return false;
        }

        private boolean hasRemainingSeries() {
            boolean remaining = false;
            for (Iterator<Map<String, List<ChunkMetadata>>> iterator : this.chunkMetadataIteratorMap.values()) {
                remaining = remaining || iterator.hasNext();
            }
            return remaining;
        }

        public boolean hasNextSeries() {
            return !this.seriesInThisIteration.isEmpty() || this.collectSeries();
        }

        public String nextSeries() {
            if (!this.hasNextSeries()) {
                return null;
            }
            this.currentCompactingSeries = this.seriesInThisIteration.removeFirst();
            return this.currentCompactingSeries;
        }

        public LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>> getMetadataListForCurrentSeries() throws IllegalPathException {
            if (this.currentCompactingSeries == null) {
                return null;
            }
            LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>> readerAndChunkMetadataForThisSeries = new LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>>();
            PartialPath path = new PartialPath(this.device, this.currentCompactingSeries);
            for (TsFileResource resource : MultiTsFileDeviceIterator.this.tsFileResourcesSortedByAsc) {
                TsFileSequenceReader reader = this.readerMap.get(resource);
                Map<String, List<ChunkMetadata>> chunkMetadataListMap = this.chunkMetadataCacheMap.get(reader);
                if (!chunkMetadataListMap.containsKey(this.currentCompactingSeries)) continue;
                List<ChunkMetadata> chunkMetadataListInThisResource = chunkMetadataListMap.get(this.currentCompactingSeries);
                chunkMetadataListMap.remove(this.currentCompactingSeries);
                List modificationsInThisResource = MultiTsFileDeviceIterator.this.modificationCache.computeIfAbsent(resource, r -> new LinkedList<Modification>(ModificationFile.getNormalMods(r).getModifications()));
                LinkedList<Modification> modificationForCurrentSeries = new LinkedList<Modification>();
                for (Modification modification : modificationsInThisResource) {
                    if (!modification.getPath().matchFullPath(path)) continue;
                    modificationForCurrentSeries.add(modification);
                }
                if (modificationForCurrentSeries.size() != 0) {
                    ModificationUtils.modifyChunkMetaData(chunkMetadataListInThisResource, modificationForCurrentSeries);
                }
                readerAndChunkMetadataForThisSeries.add((Pair<TsFileSequenceReader, List<ChunkMetadata>>)new Pair((Object)reader, chunkMetadataListInThisResource));
            }
            return readerAndChunkMetadataForThisSeries;
        }
    }
}

