/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.client;

import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.property.ClientPoolProperty;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.db.client.ConfigNodeClient;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;

public class DataNodeClientPoolFactory {
    private static final IoTDBConfig conf = IoTDBDescriptor.getInstance().getConfig();

    private DataNodeClientPoolFactory() {
    }

    public static class ClusterDeletionConfigNodeClientPoolFactory
    implements IClientPoolFactory<ConfigRegionId, ConfigNodeClient> {
        public KeyedObjectPool<ConfigRegionId, ConfigNodeClient> createClientPool(ClientManager<ConfigRegionId, ConfigNodeClient> manager) {
            return new GenericKeyedObjectPool((KeyedPooledObjectFactory)new ConfigNodeClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(conf.getConnectionTimeoutInMS() * 10).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnable()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager() / 10 > 0 ? conf.getSelectorNumOfClientManager() / 10 : 1).build()), new ClientPoolProperty.Builder().setCoreClientNumForEachNode(conf.getCoreClientNumForEachNode()).setMaxClientNumForEachNode(conf.getMaxClientNumForEachNode()).build().getConfig());
        }
    }

    public static class ConfigNodeClientPoolFactory
    implements IClientPoolFactory<ConfigRegionId, ConfigNodeClient> {
        public KeyedObjectPool<ConfigRegionId, ConfigNodeClient> createClientPool(ClientManager<ConfigRegionId, ConfigNodeClient> manager) {
            return new GenericKeyedObjectPool((KeyedPooledObjectFactory)new ConfigNodeClient.Factory(manager, new ThriftClientProperty.Builder().setConnectionTimeoutMs(conf.getConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnable()).build()), new ClientPoolProperty.Builder().setCoreClientNumForEachNode(conf.getCoreClientNumForEachNode()).setMaxClientNumForEachNode(conf.getMaxClientNumForEachNode()).build().getConfig());
        }
    }
}

