
package org.apache.iotdb.db.mpp.execution.operator.window;

import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;

/*
* This class is generated using freemarker and the variationWindowManager.ftl template.
*/
public class VariationDoubleWindowManager extends VariationWindowManager {

  public VariationDoubleWindowManager(
      VariationWindowParameter variationWindowParameter, boolean ascending) {
    super(ascending);
    variationWindow = new VariationDoubleWindow(variationWindowParameter);
  }

  @Override
  public TsBlock skipPointsOutOfCurWindow(TsBlock inputTsBlock) {
    if (!needSkip) {
      return inputTsBlock;
    }

    if (inputTsBlock == null || inputTsBlock.isEmpty()) {
      return inputTsBlock;
    }

    Column controlColumn = variationWindow.getControlColumn(inputTsBlock);
    TimeColumn timeColumn = inputTsBlock.getTimeColumn();
    int i = 0, size = inputTsBlock.getPositionCount();
    double previousValue = ((VariationDoubleWindow) variationWindow).getPreviousHeadValue();
    boolean previousValueIsNull = ((VariationDoubleWindow) variationWindow).valueIsNull();
    for (; i < size; i++) {
      // condition must be initialized when isNull is false
      boolean condition = false;
      boolean isNull = controlColumn.isNull(i);
      if(!isNull) condition = Math.abs(controlColumn.getDouble(i) - previousValue)
          > variationWindow.getDelta();
      if(isIgnoringNull()){
        if (!isNull && condition) {
            break;
        }else if(isNull){
            continue;
        }
      }else{
        if((isNull&&!previousValueIsNull)||!isNull&&previousValueIsNull||(!isNull&&condition)){
            break;
        }
      }

      long currentTime = timeColumn.getLong(i);
      // judge whether we need update startTime
      if (variationWindow.getStartTime() > currentTime) {
        variationWindow.setStartTime(currentTime);
      }
      // judge whether we need update endTime
      if (variationWindow.getEndTime() < currentTime) {
        variationWindow.setEndTime(currentTime);
      }
    }
    // we can create a new window beginning at index i of inputTsBlock
    if (i < size) {
      needSkip = false;
    }
    return inputTsBlock.subTsBlock(i);
  }
}



