package org.apache.iotdb.db.mpp.execution.operator.window;

import org.apache.iotdb.tsfile.read.common.block.column.Column;

/*
* This class is generated using freemarker and the abstractVariationWindow.ftl template.
*/
public abstract class AbstractVariationIntWindow extends AbstractVariationWindow {

  protected int headValue;

  private int previousValue;

  public AbstractVariationIntWindow(VariationWindowParameter variationWindowParameter) {
    super(variationWindowParameter);
  }

  @Override
  public void updatePreviousValue() {
    previousValue = headValue;
  }

  @Override
  public void mergeOnePoint(Column[] controlTimeAndValueColumn, int index) {
    long currentTime = controlTimeAndValueColumn[1].getLong(index);
    // judge whether we need update startTime
    if (startTime > currentTime) {
      startTime = currentTime;
    }
    // judge whether we need update endTime
    if (endTime < currentTime) {
      endTime = currentTime;
    }
    // judge whether we need initialize eventValue
    if (!initializedHeadValue) {
      startTime = currentTime;
      endTime = currentTime;
      if(controlTimeAndValueColumn[0].isNull(index)){
        valueIsNull = true;
      }else{
        valueIsNull = false;
        headValue = controlTimeAndValueColumn[0].getInt(index);
      }
      initializedHeadValue = true;
    }
  }

  public int getHeadValue() {
    return headValue;
  }

  public int getPreviousHeadValue() {
    return previousValue;
  }
}


