package org.apache.iotdb.db.mpp.execution.operator.window;

import org.apache.iotdb.tsfile.read.common.block.column.Column;

/*
* This class is generated using freemarker and the abstractVariationWindow.ftl template.
*/
public abstract class AbstractVariationDoubleWindow extends AbstractVariationWindow {

  protected double headValue;

  private double previousValue;

  public AbstractVariationDoubleWindow(VariationWindowParameter variationWindowParameter) {
    super(variationWindowParameter);
  }

  @Override
  public void updatePreviousValue() {
    previousValue = headValue;
  }

  @Override
  public void mergeOnePoint(Column[] controlTimeAndValueColumn, int index) {
    long currentTime = controlTimeAndValueColumn[1].getLong(index);
    // judge whether we need update startTime
    if (startTime > currentTime) {
      startTime = currentTime;
    }
    // judge whether we need update endTime
    if (endTime < currentTime) {
      endTime = currentTime;
    }
    // judge whether we need initialize eventValue
    if (!initializedHeadValue) {
      startTime = currentTime;
      endTime = currentTime;
      if(controlTimeAndValueColumn[0].isNull(index)){
        valueIsNull = true;
      }else{
        valueIsNull = false;
        headValue = controlTimeAndValueColumn[0].getDouble(index);
      }
      initializedHeadValue = true;
    }
  }

  public double getHeadValue() {
    return headValue;
  }

  public double getPreviousHeadValue() {
    return previousValue;
  }
}


