package org.apache.iotdb.db.mpp.execution.operator.window;

import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.utils.Binary;

/*
* This class is generated using freemarker and the abstractVariationWindow.ftl template.
*/
public abstract class AbstractVariationBinaryWindow extends AbstractVariationWindow {

  protected Binary headValue;

  private Binary previousValue;

  public AbstractVariationBinaryWindow(VariationWindowParameter variationWindowParameter) {
    super(variationWindowParameter);
  }

  @Override
  public void updatePreviousValue() {
    previousValue = headValue;
  }

  @Override
  public void mergeOnePoint(Column[] controlTimeAndValueColumn, int index) {
    long currentTime = controlTimeAndValueColumn[1].getLong(index);
    // judge whether we need update startTime
    if (startTime > currentTime) {
      startTime = currentTime;
    }
    // judge whether we need update endTime
    if (endTime < currentTime) {
      endTime = currentTime;
    }
    // judge whether we need initialize eventValue
    if (!initializedHeadValue) {
      startTime = currentTime;
      endTime = currentTime;
      if(controlTimeAndValueColumn[0].isNull(index)){
        valueIsNull = true;
      }else{
        valueIsNull = false;
        headValue = controlTimeAndValueColumn[0].getBinary(index);
      }
      initializedHeadValue = true;
    }
  }

  public Binary getHeadValue() {
    return headValue;
  }

  public Binary getPreviousHeadValue() {
    return previousValue;
  }
}

