package org.apache.iotdb.db.mpp.execution.operator.process.fill.previous;

import org.apache.iotdb.db.mpp.execution.operator.process.fill.IFill;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.FloatColumn;
import org.apache.iotdb.tsfile.read.common.block.column.FloatColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.RunLengthEncodedColumn;

import java.util.Optional;

/*
* This class is generated using freemarker and the previousFill.ftl template.
*/
@SuppressWarnings("unused")
public class FloatPreviousFill implements IFill {

  // previous value
  private float value;
  // whether previous value is null
  private boolean previousIsNull = true;

  @Override
  public Column fill(Column valueColumn) {
    int size = valueColumn.getPositionCount();
    // if this valueColumn is empty, just return itself;
    if (size == 0) {
      return valueColumn;
    }
    // if this valueColumn doesn't have any null value, record the last value, and then return
    // itself.
    if (!valueColumn.mayHaveNull()) {
      previousIsNull = false;
      // update the value using last non-null value
      value = valueColumn.getFloat(size - 1);
      return valueColumn;
    }
    // if its values are all null
    if (valueColumn instanceof RunLengthEncodedColumn) {
      if (previousIsNull) {
        return new RunLengthEncodedColumn(FloatColumnBuilder.NULL_VALUE_BLOCK, size);
      } else {
        return new RunLengthEncodedColumn(
            new FloatColumn(1, Optional.empty(), new float[] {value}), size);
      }
    } else {
      float[] array = new float[size];
      boolean[] isNull = new boolean[size];
      // have null value
      boolean hasNullValue = false;
      for (int i = 0; i < size; i++) {
        if (valueColumn.isNull(i)) {
          if (previousIsNull) {
            isNull[i] = true;
            hasNullValue = true;
          } else {
            array[i] = value;
          }
        } else {
          array[i] = valueColumn.getFloat(i);
          value = array[i];
          previousIsNull = false;
        }
      }
      if (hasNullValue) {
        return new FloatColumn(size, Optional.of(isNull), array);
      } else {
        return new FloatColumn(size, Optional.empty(), array);
      }
    }
  }
}

