package org.apache.iotdb.db.mpp.execution.operator.process.fill.previous;

import org.apache.iotdb.db.mpp.execution.operator.process.fill.IFill;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.DoubleColumn;
import org.apache.iotdb.tsfile.read.common.block.column.DoubleColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.RunLengthEncodedColumn;

import java.util.Optional;

/*
* This class is generated using freemarker and the previousFill.ftl template.
*/
@SuppressWarnings("unused")
public class DoublePreviousFill implements IFill {

  // previous value
  private double value;
  // whether previous value is null
  private boolean previousIsNull = true;

  @Override
  public Column fill(Column valueColumn) {
    int size = valueColumn.getPositionCount();
    // if this valueColumn is empty, just return itself;
    if (size == 0) {
      return valueColumn;
    }
    // if this valueColumn doesn't have any null value, record the last value, and then return
    // itself.
    if (!valueColumn.mayHaveNull()) {
      previousIsNull = false;
      // update the value using last non-null value
      value = valueColumn.getDouble(size - 1);
      return valueColumn;
    }
    // if its values are all null
    if (valueColumn instanceof RunLengthEncodedColumn) {
      if (previousIsNull) {
        return new RunLengthEncodedColumn(DoubleColumnBuilder.NULL_VALUE_BLOCK, size);
      } else {
        return new RunLengthEncodedColumn(
            new DoubleColumn(1, Optional.empty(), new double[] {value}), size);
      }
    } else {
      double[] array = new double[size];
      boolean[] isNull = new boolean[size];
      // have null value
      boolean hasNullValue = false;
      for (int i = 0; i < size; i++) {
        if (valueColumn.isNull(i)) {
          if (previousIsNull) {
            isNull[i] = true;
            hasNullValue = true;
          } else {
            array[i] = value;
          }
        } else {
          array[i] = valueColumn.getDouble(i);
          value = array[i];
          previousIsNull = false;
        }
      }
      if (hasNullValue) {
        return new DoubleColumn(size, Optional.of(isNull), array);
      } else {
        return new DoubleColumn(size, Optional.empty(), array);
      }
    }
  }
}

