package org.apache.iotdb.db.mpp.execution.operator.process.fill.previous;

import org.apache.iotdb.db.mpp.execution.operator.process.fill.IFill;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.BooleanColumn;
import org.apache.iotdb.tsfile.read.common.block.column.BooleanColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.RunLengthEncodedColumn;

import java.util.Optional;

/*
* This class is generated using freemarker and the previousFill.ftl template.
*/
@SuppressWarnings("unused")
public class BooleanPreviousFill implements IFill {

  // previous value
  private boolean value;
  // whether previous value is null
  private boolean previousIsNull = true;

  @Override
  public Column fill(Column valueColumn) {
    int size = valueColumn.getPositionCount();
    // if this valueColumn is empty, just return itself;
    if (size == 0) {
      return valueColumn;
    }
    // if this valueColumn doesn't have any null value, record the last value, and then return
    // itself.
    if (!valueColumn.mayHaveNull()) {
      previousIsNull = false;
      // update the value using last non-null value
      value = valueColumn.getBoolean(size - 1);
      return valueColumn;
    }
    // if its values are all null
    if (valueColumn instanceof RunLengthEncodedColumn) {
      if (previousIsNull) {
        return new RunLengthEncodedColumn(BooleanColumnBuilder.NULL_VALUE_BLOCK, size);
      } else {
        return new RunLengthEncodedColumn(
            new BooleanColumn(1, Optional.empty(), new boolean[] {value}), size);
      }
    } else {
      boolean[] array = new boolean[size];
      boolean[] isNull = new boolean[size];
      // have null value
      boolean hasNullValue = false;
      for (int i = 0; i < size; i++) {
        if (valueColumn.isNull(i)) {
          if (previousIsNull) {
            isNull[i] = true;
            hasNullValue = true;
          } else {
            array[i] = value;
          }
        } else {
          array[i] = valueColumn.getBoolean(i);
          value = array[i];
          previousIsNull = false;
        }
      }
      if (hasNullValue) {
        return new BooleanColumn(size, Optional.of(isNull), array);
      } else {
        return new BooleanColumn(size, Optional.empty(), array);
      }
    }
  }
}

